/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.cell;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.api.component.cell.RatingCell;
import net.n2oapp.framework.autotest.impl.component.cell.N2oCell;

public class N2oRatingCell
extends N2oCell
implements RatingCell {
    @Override
    public void shouldHaveMax(int max) {
        this.ratingInput().last().shouldHave(new WebElementCondition[]{Condition.attribute((String)"value", (String)String.valueOf(max))});
    }

    @Override
    public void shouldHaveValue(String value, Duration ... duration) {
        this.should(Condition.value((String)value), this.ratingInput().find(Condition.selected), duration);
    }

    @Override
    public void value(String value) {
        this.element().$$(".rating__label").find(Condition.attributeMatching((String)"for", (String)String.format("rating-%s.*", value))).click();
    }

    protected ElementsCollection ratingInput() {
        ElementsCollection ratings = this.element().$$(".rating__input--readonly");
        if (ratings.isEmpty()) {
            return this.element().$$(".rating__input");
        }
        return ratings;
    }
}

