/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.cell;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.component.Tooltip;
import net.n2oapp.framework.autotest.api.component.cell.Cell;
import net.n2oapp.framework.autotest.impl.component.N2oComponent;

public class N2oCell
extends N2oComponent
implements Cell {
    private static final String EXPAND_ICON_SELECTOR = ".n2o-advanced-table-expand .n2o-advanced-table-expand-icon";

    @Override
    public void shouldBeEmpty(Duration ... duration) {
        this.should(Condition.empty, duration);
    }

    @Override
    public void shouldBeExpandable() {
        this.expandIcon().shouldBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldNotBeExpandable() {
        this.expandIcon().shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void shouldBeExpanded() {
        this.expandIcon().shouldHave(new WebElementCondition[]{Condition.cssClass((String)"fa-angle-down")});
    }

    @Override
    public void shouldBeCollapsed() {
        this.expandIcon().shouldHave(new WebElementCondition[]{Condition.cssClass((String)"fa-angle-right")});
    }

    @Override
    public void expand() {
        this.expandIcon().shouldBe(new WebElementCondition[]{Condition.exist}).click();
    }

    @Override
    public void shouldHaveIcon(String icon) {
        this.element().$(".n2o-icon").shouldHave(new WebElementCondition[]{Condition.cssClass((String)icon)});
    }

    @Override
    public void shouldNotHaveIcon() {
        this.element().$(".n2o-icon").shouldNotBe(new WebElementCondition[]{Condition.exist});
    }

    protected SelenideElement expandIcon() {
        return this.element().$(EXPAND_ICON_SELECTOR);
    }

    @Override
    public void shouldHaveAlignment(String alignment) {
        this.element().shouldHave(new WebElementCondition[]{Condition.attribute((String)"align", (String)alignment)});
    }

    @Override
    public Tooltip tooltip() {
        SelenideElement element = this.element().$(".tooltip-container");
        return N2oSelenide.component(element, Tooltip.class);
    }

    @Override
    public void hover() {
        this.element().hover();
    }
}

