/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.button;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.WebElementCondition;
import java.time.Duration;
import java.util.Arrays;
import net.n2oapp.framework.autotest.BadgePosition;
import net.n2oapp.framework.autotest.api.component.button.StandardButton;
import net.n2oapp.framework.autotest.impl.component.button.N2oButton;

public class N2oStandardButton
extends N2oButton
implements StandardButton {
    @Override
    public void shouldHaveLabel(String label, Duration ... duration) {
        this.should(Condition.exactText((String)label), duration);
    }

    @Override
    public void shouldHaveDescription(String description, Duration ... duration) {
        this.element().shouldHave(new WebElementCondition[]{Condition.attribute((String)"hint", (String)description)});
    }

    @Override
    public void shouldHaveIcon(String iconName) {
        Arrays.stream(iconName.split(" ")).forEach(i -> this.element().$("i").shouldHave(new WebElementCondition[]{Condition.cssClass((String)i)}));
    }

    @Override
    public void shouldNotHaveIcon() {
        this.element().$("i").shouldNot(new WebElementCondition[]{Condition.exist});
    }

    @Override
    public void badgeShouldHavePosition(BadgePosition position) {
        this.shouldHaveCssClass(position.name("btn-badge-position--"));
    }

    @Override
    public void shouldBeRounded() {
        this.element().shouldHave(new WebElementCondition[]{Condition.cssClass((String)"btn-rounded__with-content")});
    }

    @Override
    public void shouldNotBeRounded() {
        this.element().shouldNotHave(new WebElementCondition[]{Condition.cssClass((String)"btn-rounded__with-content")});
    }
}

