/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component.button;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.WebElementsCondition;
import java.time.Duration;
import java.util.Arrays;
import net.n2oapp.framework.autotest.N2oSelenide;
import net.n2oapp.framework.autotest.api.component.button.DropdownButton;
import net.n2oapp.framework.autotest.api.component.button.StandardButton;
import net.n2oapp.framework.autotest.impl.component.button.N2oButton;
import net.n2oapp.framework.autotest.impl.component.button.N2oStandardButton;

public class N2oDropdownButton
extends N2oButton
implements DropdownButton {
    private final String DROPDOWN = ".n2o-dropdown-menu,.dropdown-menu";

    @Override
    public void shouldHaveLabel(String label, Duration ... duration) {
        this.should(Condition.exactText((String)label), duration);
    }

    @Override
    public void shouldHaveItems(int count) {
        this.menuItems().shouldHave(new WebElementsCondition[]{CollectionCondition.size((int)count)});
    }

    @Override
    public StandardButton menuItem(String label) {
        return this.menuItem(Condition.text((String)label));
    }

    @Override
    public StandardButton menuItem(WebElementCondition by) {
        return N2oSelenide.component(this.menuItems().findBy(by), N2oStandardButton.class);
    }

    @Override
    public StandardButton menuItem(int index) {
        return N2oSelenide.component(this.menuItems().get(index), N2oStandardButton.class);
    }

    @Override
    public void shouldBeVisible() {
        this.element().parent().shouldBe(new WebElementCondition[]{Condition.visible});
    }

    @Override
    public void shouldBeHidden() {
        this.element().parent().shouldBe(new WebElementCondition[]{Condition.hidden});
    }

    @Override
    public void shouldBeExpanded() {
        this.dropdownMenu().shouldBe(new WebElementCondition[]{Condition.visible});
    }

    @Override
    public void shouldBeCollapsed() {
        this.dropdownMenu().shouldBe(new WebElementCondition[]{Condition.hidden});
    }

    @Override
    public void shouldHaveIcon(String iconName) {
        Arrays.stream(iconName.split(" ")).forEach(i -> this.element().$("i").shouldHave(new WebElementCondition[]{Condition.cssClass((String)i)}));
    }

    private SelenideElement dropdownMenu() {
        if (this.element().parent().$(".n2o-dropdown-menu,.dropdown-menu").exists()) {
            return this.element().parent().$(".n2o-dropdown-menu,.dropdown-menu");
        }
        return this.element().parent().parent().$(".n2o-dropdown-menu,.dropdown-menu");
    }

    protected ElementsCollection menuItems() {
        return this.dropdownMenu().$$("div.dropdown-menu .btn.btn-secondary,.dropdown-item");
    }
}

