/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.impl.component;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.WebElementsCondition;
import java.time.Duration;
import java.util.Arrays;
import java.util.OptionalInt;
import net.n2oapp.framework.autotest.Colors;
import net.n2oapp.framework.autotest.api.component.DropDown;
import net.n2oapp.framework.autotest.impl.component.N2oComponent;

public class N2oDropDown
extends N2oComponent
implements DropDown {
    @Override
    public DropDown.DropDownItem item(int index) {
        return new N2oDropDownItem(this.itemByIndex(index));
    }

    @Override
    public DropDown.DropDownItem item(String label) {
        return new N2oDropDownItem(this.itemByLabel(label));
    }

    @Override
    public void shouldHaveOptions(String[] options, Duration ... duration) {
        if (options.length > 0) {
            this.items().shouldBe(new WebElementsCondition[]{CollectionCondition.sizeGreaterThan((int)(options.length - 1))});
            this.should(CollectionCondition.exactTexts((String[])options), this.element().$$(".dropdown-item .text-cropped, .dropdown-item .custom-control-label"), duration);
        }
    }

    @Override
    public void selectItem(int index) {
        ((ElementsCollection)this.items().shouldBe(new WebElementsCondition[]{CollectionCondition.sizeGreaterThan((int)index)})).get(index).click();
    }

    @Override
    public void selectItemBy(WebElementCondition by) {
        this.items().findBy(by).click();
    }

    @Override
    public void selectMulti(int ... indexes) {
        OptionalInt maxIndex = Arrays.stream(indexes).max();
        ElementsCollection items = this.items();
        if (maxIndex.isPresent()) {
            this.items().shouldBe(new WebElementsCondition[]{CollectionCondition.sizeGreaterThan((int)maxIndex.getAsInt())});
            Arrays.stream(indexes).forEach(index -> items.get(index).click());
        }
    }

    @Override
    public void shouldBeChecked(int ... indexes) {
        OptionalInt maxIndex = Arrays.stream(indexes).max();
        ElementsCollection items = this.items();
        if (maxIndex.isPresent()) {
            Arrays.stream(indexes).forEach(index -> items.get(index).$(".n2o-input").shouldBe(new WebElementCondition[]{Condition.checked}));
        }
    }

    @Override
    public void shouldNotBeChecked(int ... indexes) {
        OptionalInt maxIndex = Arrays.stream(indexes).max();
        ElementsCollection items = this.items();
        if (maxIndex.isPresent()) {
            Arrays.stream(indexes).forEach(index -> items.get(index).$(".n2o-input").shouldNotBe(new WebElementCondition[]{Condition.checked}));
        }
    }

    @Override
    public void shouldHaveOptions(int size) {
        this.items().shouldHave(new WebElementsCondition[]{CollectionCondition.size((int)size)});
    }

    @Override
    public void scrollDown() {
        Selenide.executeJavaScript((String)"arguments[0].scrollTop = arguments[0].scrollHeight", (Object[])new Object[]{this.element().getWrappedElement()});
    }

    private ElementsCollection items() {
        return this.element().$$(".dropdown-item");
    }

    private SelenideElement itemByIndex(int index) {
        return this.items().get(index);
    }

    private SelenideElement itemByLabel(String label) {
        return this.items().findBy(Condition.text((String)label));
    }

    public class N2oDropDownItem
    extends N2oComponent
    implements DropDown.DropDownItem {
        public N2oDropDownItem(SelenideElement element) {
            this.setElement(element);
        }

        @Override
        public void shouldHaveValue(String value, Duration ... duration) {
            this.should(Condition.text((String)value), duration);
        }

        @Override
        public void shouldBeSelected() {
            this.element().shouldHave(new WebElementCondition[]{Condition.cssClass((String)"selected")});
        }

        @Override
        public void shouldNotBeSelected() {
            this.element().shouldNotHave(new WebElementCondition[]{Condition.cssClass((String)"selected")});
        }

        @Override
        public void shouldHaveDescription(String description, Duration ... duration) {
            this.should(Condition.text((String)description), this.element().$(".dropdown-header"), duration);
        }

        @Override
        public void shouldHaveStatusColor(Colors color) {
            this.element().$(".n2o-status-text_icon__right, .n2o-status-text_icon__left").shouldHave(new WebElementCondition[]{Condition.cssClass((String)color.name("bg-"))});
        }

        @Override
        public void shouldBeEnabled() {
            this.element().shouldBe(new WebElementCondition[]{Condition.enabled});
        }

        @Override
        public void shouldBeDisabled() {
            this.element().shouldBe(new WebElementCondition[]{Condition.disabled});
        }
    }
}

