/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.autotest.api.component;

import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebElementCondition;
import com.codeborne.selenide.WebElementsCondition;
import java.time.Duration;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.autotest.api.component.Element;

public interface Component
extends Element {
    public void shouldExists();

    public void shouldNotExists(Duration ... var1);

    public void shouldBeVisible();

    public void shouldBeHidden();

    public void shouldHaveCssClass(String var1);

    public void shouldHaveStyle(String var1);

    default public SelenideElement should(WebElementCondition condition, Duration ... duration) {
        if (duration.length > 1) {
            throw new N2oException("Expected duration length 1 or less, but received %d" + duration.length);
        }
        if (duration.length == 1) {
            return this.element().should(condition, duration[0]);
        }
        return this.element().should(new WebElementCondition[]{condition});
    }

    default public SelenideElement should(WebElementCondition condition, SelenideElement element, Duration ... duration) {
        if (duration.length > 1) {
            throw new N2oException("Expected duration length 1 or less, but received %d" + duration.length);
        }
        if (duration.length == 1) {
            return element.should(condition, duration[0]);
        }
        return element.should(new WebElementCondition[]{condition});
    }

    default public ElementsCollection should(WebElementsCondition condition, ElementsCollection element, Duration ... duration) {
        if (duration.length == 1) {
            return (ElementsCollection)element.should(condition, duration[0]);
        }
        return (ElementsCollection)element.should(new WebElementsCondition[]{condition});
    }
}

