/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.boot.stomp;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.action.N2oAction;
import net.n2oapp.framework.api.metadata.application.N2oApplication;
import net.n2oapp.framework.api.metadata.event.N2oAbstractEvent;
import net.n2oapp.framework.api.metadata.event.N2oStompEvent;
import net.n2oapp.framework.api.metadata.meta.action.AbstractAction;
import net.n2oapp.framework.api.metadata.pipeline.ReadPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadTerminalPipeline;
import net.n2oapp.framework.api.register.SourceInfo;
import net.n2oapp.framework.boot.stomp.N2oStompException;
import net.n2oapp.framework.boot.stomp.WebSocketController;
import net.n2oapp.framework.config.metadata.compile.N2oCompileProcessor;
import net.n2oapp.framework.config.register.route.RouteUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;

public class N2oWebSocketController
implements WebSocketController {
    private static final String APPLICATION_DEFAULT_NAME = "default";
    private ReadPipeline pipeline;
    private MetadataEnvironment environment;
    private ObjectMapper mapper;
    @Autowired
    private SimpMessagingTemplate messagingTemplate;

    public N2oWebSocketController(ReadPipeline pipeline, MetadataEnvironment environment, ObjectMapper mapper) {
        this.pipeline = pipeline;
        this.environment = environment;
        this.mapper = mapper;
    }

    public void setPipeline(ReadPipeline pipeline) {
        this.pipeline = pipeline;
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public void convertAndSend(String destination, Object message) {
        destination = RouteUtil.normalize((String)destination);
        this.messagingTemplate.convertAndSend((Object)destination, this.initAction(destination, message));
    }

    @Override
    public void convertAndSendToUser(String user, String destination, Object message) {
        destination = RouteUtil.normalize((String)destination);
        this.messagingTemplate.convertAndSendToUser(user, destination, this.initAction(destination, message));
    }

    private AbstractAction<?, ?> initAction(String destination, Object message) {
        N2oApplication application = this.getSourceApplication();
        N2oAction stompAction = this.getStompAction(destination, application);
        N2oCompileProcessor p = new N2oCompileProcessor(this.environment);
        return (AbstractAction)p.compile(this.resolveLinks(stompAction, message), null, new Object[0]);
    }

    private Object resolveLinks(Object stompAction, Object message) {
        Map sourceMap = (Map)this.mapper.convertValue(stompAction, Map.class);
        Map messageActionMap = (Map)this.mapper.convertValue(message, Map.class);
        for (Map.Entry attr : sourceMap.entrySet()) {
            if (!StringUtils.isLink(attr.getValue())) continue;
            String text = StringUtils.unwrapLink((String)((String)attr.getValue()));
            sourceMap.put((String)attr.getKey(), messageActionMap.get(text) != null ? messageActionMap.get(text).toString() : null);
        }
        return this.mapper.convertValue((Object)sourceMap, stompAction.getClass());
    }

    private N2oAction getStompAction(String destination, N2oApplication application) {
        if (destination == null) {
            throw new N2oStompException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u043c\u0435\u0441\u0442\u043e \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f");
        }
        if (application.getEvents() == null) {
            throw new N2oStompException("\u0412 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u0441\u043e\u0431\u044b\u0442\u0438\u044f");
        }
        for (N2oAbstractEvent event : application.getEvents()) {
            if (!(event instanceof N2oStompEvent) || !destination.equals(((N2oStompEvent)event).getDestination())) continue;
            return ((N2oStompEvent)event).getAction();
        }
        throw new N2oStompException(String.format("\u0412 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u0441\u043e\u0431\u044b\u0442\u0438\u044f \u0441 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u043c\u0435\u0441\u0442\u043e\u043c \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f %s", destination));
    }

    private N2oApplication getSourceApplication() {
        return (N2oApplication)((ReadTerminalPipeline)this.pipeline.read()).get(this.getApplicationId(this.environment), N2oApplication.class);
    }

    private String getApplicationId(MetadataEnvironment environment) {
        List sourceInfos = environment.getMetadataRegister().find(N2oApplication.class);
        if (sourceInfos == null || sourceInfos.isEmpty()) {
            return APPLICATION_DEFAULT_NAME;
        }
        return sourceInfos.stream().map(SourceInfo::getId).filter(s -> !APPLICATION_DEFAULT_NAME.equals(s)).findFirst().orElse(APPLICATION_DEFAULT_NAME);
    }
}

