/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.boot.sql.rowmapper;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import net.n2oapp.framework.boot.sql.PostgresUtil;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;

public class PostgresMapRowMapper
implements RowMapper<Map<String, Object>> {
    public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
        int columnCount = rs.getMetaData().getColumnCount();
        LinkedCaseInsensitiveMap result = new LinkedCaseInsensitiveMap(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            result.putIfAbsent(JdbcUtils.lookupColumnName((ResultSetMetaData)rs.getMetaData(), (int)i), PostgresUtil.resolveValue(rs.getObject(i)));
        }
        return result;
    }
}

