/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.boot.sql;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import net.n2oapp.engine.factory.EngineFactory;
import net.n2oapp.engine.factory.TypicalEngine;
import net.n2oapp.engine.factory.integration.spring.SpringEngineFactory;
import net.n2oapp.framework.api.data.MapInvocationEngine;
import net.n2oapp.framework.api.data.exception.N2oQueryExecutionException;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.dataprovider.N2oSqlDataProvider;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.engine.data.QueryUtil;
import net.n2oapp.framework.engine.util.NamedParameterUtils;
import net.n2oapp.framework.engine.util.QueryBlank;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class SqlDataProviderEngine
implements MapInvocationEngine<N2oSqlDataProvider>,
ApplicationContextAware,
ResourceLoaderAware {
    private static final Logger log = LoggerFactory.getLogger(SqlDataProviderEngine.class);
    private static final Pattern SQL_ERROR_PATTERN = Pattern.compile("(\\A|\n)[A-Z][a-z](.|\n)+?; SQL statement:");
    @Autowired
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private String defaultJdbcDriver;
    private EngineFactory<String, RowMapper> rowMapperFactory;
    private ResourceLoader resourceLoader;

    public Object invoke(N2oSqlDataProvider invocation, Map<String, Object> data) {
        HashMap<String, Object> args = new HashMap<String, Object>(data);
        String query = this.loadQuery(invocation);
        query = QueryUtil.replaceListPlaceholder((String)query, (String)":select", args.remove("select"), (String)"*", QueryUtil::reduceComma);
        query = QueryUtil.replaceListPlaceholder((String)query, (String)":join", args.remove("join"), (String)"", QueryUtil::reduceSpace);
        query = QueryUtil.replaceListPlaceholder((String)query, (String)":filters", args.remove("filters"), (String)"1=1", QueryUtil::reduceAnd);
        query = QueryUtil.replaceListPlaceholder((String)query, (String)":sorting", args.remove("sorting"), (String)"1", s -> this.replaceSortDirection((String)s, data), QueryUtil::reduceComma);
        query = QueryUtil.replacePlaceholder((String)query, (String)":limit", args.remove("limit"), (String)"10");
        query = QueryUtil.replacePlaceholder((String)query, (String)":offset", args.remove("offset"), (String)"0");
        query = QueryUtil.replacePlaceholder((String)query, (String)":count", args.remove("count"), (String)"-1");
        log.debug("Execute SQL query: " + query);
        try {
            if (invocation.getConnectionUrl() == null) {
                return this.executeQuery(args, query, (RowMapper)this.rowMapperFactory.produce((Object)((String)CompileUtil.castDefault((Object)invocation.getRowMapper(), (Object)"map", (Object[])new String[0]))), this.namedParameterJdbcTemplate);
            }
            NamedParameterJdbcTemplate jdbcTemplate = this.createJdbcTemplate(invocation);
            return this.executeQuery(args, query, (RowMapper)this.rowMapperFactory.produce((Object)((String)CompileUtil.castDefault((Object)invocation.getRowMapper(), (Object)"map", (Object[])new String[0]))), jdbcTemplate);
        }
        catch (DataAccessException e) {
            log.error("Execution error with SQL query: " + query);
            throw new N2oQueryExecutionException(this.constructSqlMessage(e), query, (Throwable)e);
        }
    }

    private String replaceSortDirection(String sortCause, Map<String, Object> data) {
        return QueryUtil.replacePlaceholders((String)sortCause, t -> t.startsWith(":"), p -> data.get(p.substring(1)));
    }

    private String loadQuery(N2oSqlDataProvider invocation) {
        if (invocation.getFilePath() != null) {
            String string;
            block10: {
                if (this.resourceLoader == null) {
                    throw new IllegalStateException("Resource Loader should not be null");
                }
                InputStream is = this.resourceLoader.getResource(invocation.getFilePath()).getInputStream();
                try {
                    string = IOUtils.toString((InputStream)is, (String)"UTF-8");
                    if (is == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new N2oException((Throwable)e);
                    }
                }
                is.close();
            }
            return string;
        }
        return invocation.getQuery();
    }

    public Class<? extends N2oSqlDataProvider> getType() {
        return N2oSqlDataProvider.class;
    }

    private Object executeQuery(Map<String, Object> args, String query, RowMapper<?> mapper, NamedParameterJdbcTemplate jdbcTemplate) {
        QueryBlank queryBlank = NamedParameterUtils.prepareQuery((String)query, args);
        query = queryBlank.getQuery();
        args = queryBlank.getArgs();
        if (this.isSelect(query)) {
            return jdbcTemplate.query(query, args, mapper);
        }
        MapSqlParameterSource paramSource = new MapSqlParameterSource(args);
        GeneratedKeyHolder generatedKeyHolder = new GeneratedKeyHolder();
        jdbcTemplate.update(query, (SqlParameterSource)paramSource, (KeyHolder)generatedKeyHolder);
        return this.getResult(generatedKeyHolder);
    }

    private Object getResult(GeneratedKeyHolder generatedKeyHolder) {
        List keyList = generatedKeyHolder.getKeyList();
        if (keyList != null) {
            if (keyList.size() > 1) {
                ArrayList<Object[]> rows = new ArrayList<Object[]>(keyList.size());
                for (Map row : keyList) {
                    rows.add(row.values().toArray());
                }
                return rows.toArray();
            }
            if (keyList.size() == 1) {
                return ((Map)keyList.get(0)).values().toArray();
            }
        }
        return null;
    }

    private boolean isSelect(String query) {
        return query.trim().toLowerCase().startsWith("select");
    }

    public void setNamedParameterJdbcTemplate(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.rowMapperFactory = new SpringEngineFactory<String, RowMapper>(applicationContext){

            public Class<RowMapper> getEngineClass() {
                return RowMapper.class;
            }

            public String getType(RowMapper engine) {
                if (engine instanceof TypicalEngine) {
                    return (String)((TypicalEngine)engine).getType();
                }
                return engine.getClass().getSimpleName();
            }
        };
    }

    public void setRowMapperFactory(EngineFactory<String, RowMapper> rowMapperFactory) {
        this.rowMapperFactory = rowMapperFactory;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setDefaultJdbcDriver(String defaultJdbcDriver) {
        this.defaultJdbcDriver = defaultJdbcDriver;
    }

    private NamedParameterJdbcTemplate createJdbcTemplate(N2oSqlDataProvider invocation) {
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(invocation.getJdbcDriver() == null ? this.defaultJdbcDriver : invocation.getJdbcDriver());
        config.setJdbcUrl(invocation.getConnectionUrl());
        config.setUsername(invocation.getUsername());
        config.setPassword(invocation.getPassword());
        return new NamedParameterJdbcTemplate((DataSource)new HikariDataSource(config));
    }

    private String constructSqlMessage(DataAccessException e) {
        Matcher matcher;
        String sqlMessage = e.getMessage();
        if (e instanceof BadSqlGrammarException) {
            sqlMessage = ((BadSqlGrammarException)e).getSQLException().getMessage();
        }
        if ((matcher = SQL_ERROR_PATTERN.matcher(sqlMessage)).find()) {
            return "Bad SQL grammar: " + (matcher.group().startsWith("\n") ? StringUtils.substringBetween((String)matcher.group(), (String)"\n", (String)"; SQL statement:") : StringUtils.substringBefore((String)matcher.group(), (String)"; SQL statement:"));
        }
        return sqlMessage;
    }
}

