/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.boot.route;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.register.route.RouteInfoKey;
import net.n2oapp.framework.config.register.ConfigRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.SerializationUtils;

public class JDBCRouteRepository
implements ConfigRepository<RouteInfoKey, CompileContext> {
    private static final Logger log = LoggerFactory.getLogger(JDBCRouteRepository.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Value(value="${n2o.config.register.jdbc.table-name:route_repository}")
    private String tableName;
    @Value(value="${n2o.config.register.jdbc.create-table:false}")
    private Boolean createTable;

    public CompileContext save(RouteInfoKey key, CompileContext value) {
        String insertSQL = "INSERT INTO " + this.tableName + " VALUES (?, ?, ?, ?)";
        String updateSQL = "UPDATE " + this.tableName + " SET context=? WHERE url=? AND class=?";
        byte[] serialValue = SerializationUtils.serialize((Object)value);
        int cnt = this.jdbcTemplate.update(updateSQL, new Object[]{serialValue, key.getUrlMatching(), key.getCompiledClass().getName()});
        if (cnt < 1) {
            this.jdbcTemplate.update(insertSQL, new Object[]{UUID.randomUUID(), key.getUrlMatching(), key.getCompiledClass().getName(), serialValue});
            log.info(String.format("Inserted route: '%s' to [%s]", value, key.getUrlMatching()));
        } else {
            log.info(String.format("Updated route: '%s' to [%s]", value, key.getUrlMatching()));
        }
        return value;
    }

    public void clearAll() {
        String deleteSQL = "DELETE FROM " + this.tableName;
        this.jdbcTemplate.update(deleteSQL);
    }

    public Map<RouteInfoKey, CompileContext> getAll() {
        String selectSQL = "SELECT url, class, context FROM " + this.tableName;
        List resultSet = this.jdbcTemplate.queryForList(selectSQL);
        HashMap<RouteInfoKey, CompileContext> result = new HashMap<RouteInfoKey, CompileContext>();
        for (Map row : resultSet) {
            CompileContext context = (CompileContext)SerializationUtils.deserialize((byte[])((byte[])row.get("context")));
            result.put(new RouteInfoKey((String)row.get("url"), context.getCompiledClass()), context);
        }
        log.info(String.format("Returned %s routes.", result.size()));
        return result;
    }

    @PostConstruct
    public void createTable() {
        if (this.createTable.booleanValue()) {
            String createTableSQL = "CREATE TABLE IF NOT EXISTS " + this.tableName + " (id uuid PRIMARY KEY, url varchar(255), class varchar(255), context bytea)";
            this.jdbcTemplate.execute(createTableSQL);
            log.info(String.format("Created table %s.", this.tableName));
        }
    }
}

