/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.boot.mongodb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.BasicDBObject;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.n2oapp.framework.api.PlaceHoldersResolver;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.data.MapInvocationEngine;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.dataprovider.N2oMongoDbDataProvider;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class MongoDbDataProviderEngine
implements MapInvocationEngine<N2oMongoDbDataProvider> {
    public static final String SELECT = "select";
    public static final String SORTING = "sorting";
    public static final String FILTERS = "filters";
    @Autowired
    private MongoClient mongoClient;
    @Value(value="${n2o.engine.mongodb.database_name:}")
    private String databaseName;
    @Value(value="${spring.data.mongodb.database:}")
    private String springDatabaseName;
    private ObjectMapper mapper;
    private static final Function<String, Integer> defaultSuffixIdx = str -> {
        if (str.startsWith(".")) {
            return 0;
        }
        String[] ends = str.split("[^A-Za-z0-9_\\.]");
        return ends[0].replaceAll("\\.+$", "").length();
    };

    public MongoDbDataProviderEngine(ObjectMapper objectMapper) {
        this.mapper = objectMapper;
    }

    public Object invoke(N2oMongoDbDataProvider invocation, Map<String, Object> inParams) {
        String dbName;
        String string = invocation.getDatabaseName() != null ? invocation.getDatabaseName() : (dbName = !StringUtils.isEmpty((Object)this.databaseName) ? this.databaseName : this.springDatabaseName);
        if (invocation.getConnectionUrl() == null) {
            MongoCollection collection = this.mongoClient.getDatabase(dbName).getCollection(invocation.getCollectionName());
            return this.execute(invocation, inParams, (MongoCollection<Document>)collection);
        }
        ConnectionString connectionString = new ConnectionString(invocation.getConnectionUrl());
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(connectionString).build();
        try (MongoClient mongoClient = MongoClients.create((MongoClientSettings)mongoClientSettings);){
            MongoCollection collection = mongoClient.getDatabase(dbName).getCollection(invocation.getCollectionName());
            Object object = this.execute(invocation, inParams, (MongoCollection<Document>)collection);
            return object;
        }
    }

    public Class<? extends N2oMongoDbDataProvider> getType() {
        return N2oMongoDbDataProvider.class;
    }

    private Object execute(N2oMongoDbDataProvider invocation, Map<String, Object> inParams, MongoCollection<Document> collection) {
        if (invocation.getOperation() == null) {
            return this.find(inParams, collection);
        }
        switch (invocation.getOperation()) {
            case find: {
                return this.find(inParams, collection);
            }
            case insertOne: {
                return this.insertOne(inParams, collection);
            }
            case updateOne: {
                return this.updateOne(inParams, collection);
            }
            case deleteOne: {
                return this.deleteOne(inParams, collection);
            }
            case deleteMany: {
                return this.deleteMany(inParams, collection);
            }
            case countDocuments: {
                return this.countDocument(inParams, collection);
            }
        }
        throw new N2oException("Unsupported invocation's operation");
    }

    private Object find(Map<String, Object> inParams, MongoCollection<Document> collection) {
        Bson order = this.getSorting(inParams);
        Bson projection = inParams.containsKey(SELECT) && inParams.get(SELECT) != null ? Projections.include((List)((List)inParams.get(SELECT))) : null;
        int limit = inParams.containsKey("limit") ? (Integer)inParams.get("limit") : 10;
        int offset = inParams.containsKey("offset") ? (Integer)inParams.get("offset") : 0;
        Bson filter = this.getFilters(inParams);
        if (filter == null) {
            filter = new Document();
        }
        ArrayList<Document> result = new ArrayList<Document>();
        for (Document document : collection.find(filter).projection(projection).sort(order).limit(limit).skip(offset)) {
            result.add(document);
        }
        return result;
    }

    private Integer countDocument(Map<String, Object> inParams, MongoCollection<Document> collection) {
        Bson filter = this.getFilters(inParams);
        if (filter == null) {
            filter = new Document();
        }
        return (int)collection.countDocuments(filter);
    }

    private Bson getSorting(Map<String, Object> inParams) {
        Bson order = null;
        if (inParams.containsKey(SORTING) && inParams.get(SORTING) != null) {
            List sortings = (List)inParams.get(SORTING);
            ArrayList<Bson> sortFields = new ArrayList<Bson>();
            for (String sort : sortings) {
                String[] str = sort.replace(" ", "").split(":");
                if ("desc".equals(inParams.get(str[1]))) {
                    sortFields.add(Sorts.descending((String[])new String[]{str[0]}));
                    continue;
                }
                sortFields.add(Sorts.ascending((String[])new String[]{str[0]}));
            }
            order = Sorts.orderBy(sortFields);
        }
        return order;
    }

    private Bson getFilters(Map<String, Object> inParams) {
        Bson filters = null;
        if (inParams.containsKey(FILTERS) && inParams.get(FILTERS) != null) {
            PlaceHoldersResolver resolver = new PlaceHoldersResolver("#", "", Boolean.valueOf(false), defaultSuffixIdx);
            List filterList = (List)inParams.get(FILTERS);
            ArrayList<BasicDBObject> filtersByFields = new ArrayList<BasicDBObject>();
            for (String filter : filterList) {
                BasicDBObject f = BasicDBObject.parse((String)resolver.resolve(filter, PlaceHoldersResolver.replaceByJson((Function)PlaceHoldersResolver.replaceOptional(inParams::get), (ObjectMapper)this.mapper)));
                filtersByFields.add(f);
            }
            filters = filtersByFields.isEmpty() ? null : Filters.and(filtersByFields);
        }
        return filters;
    }

    private Object insertOne(Map<String, Object> inParams, MongoCollection<Document> collection) {
        Document document = new Document(inParams);
        collection.insertOne((Object)document);
        return document.get((Object)"_id").toString();
    }

    private Object updateOne(Map<String, Object> inParams, MongoCollection<Document> collection) {
        if (!inParams.containsKey("id")) {
            throw new N2oException("Id is required for operation \"updateOne\"");
        }
        String id = (String)inParams.get("id");
        HashMap<String, Object> data = new HashMap<String, Object>(inParams);
        data.remove("id");
        collection.updateOne(Filters.eq((String)"_id", (Object)new ObjectId(id)), (Bson)new Document("$set", (Object)new Document(data)));
        return null;
    }

    private Object deleteOne(Map<String, Object> inParams, MongoCollection<Document> collection) {
        if (!inParams.containsKey("id")) {
            throw new N2oException("Id is required for operation \"deleteOne\"");
        }
        collection.deleteOne(Filters.eq((String)"_id", (Object)new ObjectId((String)inParams.get("id"))));
        return null;
    }

    private Object deleteMany(Map<String, Object> inParams, MongoCollection<Document> collection) {
        if (!inParams.containsKey("ids")) {
            throw new N2oException("Ids is required for operation \"deleteMany\"");
        }
        Object[] ids = ((List)inParams.get("ids")).stream().map(id -> new ObjectId((String)id)).toArray();
        collection.deleteMany(Filters.in((String)"_id", (Object[])ids));
        return null;
    }

    public void setMongoClient(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setSpringDatabaseName(String springDatabaseName) {
        this.springDatabaseName = springDatabaseName;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }
}

