/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.boot.graphql;

import java.math.BigDecimal;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class GraphQlUtil {
    public static String toGraphQlString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Map) {
            StringJoiner joiner = new StringJoiner(", ", "{", "}");
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                joiner.add((String)entry.getKey() + ": " + GraphQlUtil.toGraphQlString(entry.getValue()));
            }
            return joiner.toString();
        }
        if (obj instanceof List) {
            StringJoiner joiner = new StringJoiner(", ", "[", "]");
            for (Object item : (List)obj) {
                joiner.add(GraphQlUtil.toGraphQlString(item));
            }
            return joiner.toString();
        }
        if (obj instanceof Temporal || obj instanceof Date || obj instanceof BigDecimal) {
            return "\"" + String.valueOf(obj) + "\"";
        }
        if (obj instanceof String) {
            return "\"" + GraphQlUtil.escapeJson((String)obj) + "\"";
        }
        return obj.toString();
    }

    public static String escapeJson(String raw) {
        String escaped = raw;
        escaped = escaped.replace("\\", "\\\\");
        escaped = escaped.replace("\"", "\\\"");
        escaped = escaped.replace("\b", "\\b");
        escaped = escaped.replace("\f", "\\f");
        escaped = escaped.replace("\n", "\\n");
        escaped = escaped.replace("\r", "\\r");
        escaped = escaped.replace("\t", "\\t");
        return escaped;
    }
}

