/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.boot.graphql;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.data.MapInvocationEngine;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.dataprovider.N2oGraphQlDataProvider;
import net.n2oapp.framework.boot.graphql.GraphQlUtil;
import net.n2oapp.framework.boot.graphql.N2oGraphQlException;
import net.n2oapp.framework.engine.data.QueryUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestTemplate;

public class GraphQlDataProviderEngine
implements MapInvocationEngine<N2oGraphQlDataProvider> {
    private static final Logger log = LoggerFactory.getLogger(GraphQlDataProviderEngine.class);
    private static final String RESPONSE_ERROR_KEY = "errors";
    private static final String RESPONSE_ERROR_MESSAGE_KEY = "message";
    private static final String RESPONSE_DATA_KEY = "data";
    private final Pattern variablePattern = Pattern.compile("\\$\\w+");
    private final Pattern placeholderKeyPattern = Pattern.compile("\\$\\$\\w+\\s*:");
    private final Pattern selectKeyPattern = Pattern.compile("\\$\\$\\w+\\W");
    private final Pattern placeholderStringEscapePattern = Pattern.compile("\\$\\$\\$\\w+");
    @Value(value="${n2o.engine.graphql.endpoint:}")
    private String endpoint;
    @Value(value="${n2o.engine.graphql.access-token:}")
    private String accessToken;
    @Value(value="${n2o.engine.graphql.forward-headers:}")
    private String forwardHeaders;
    @Value(value="${n2o.engine.graphql.forward-cookies:}")
    private String forwardCookies;
    @Value(value="${n2o.engine.graphql.filter-separator:}")
    private String defaultFilterSeparator;
    @Value(value="${n2o.engine.graphql.sorting-separator:}")
    private String defaultSortingSeparator;
    @Value(value="${n2o.engine.graphql.filter-prefix:}")
    private String defaultFilterPrefix;
    @Value(value="${n2o.engine.graphql.filter-suffix:}")
    private String defaultFilterSuffix;
    @Value(value="${n2o.engine.graphql.sorting-prefix:}")
    private String defaultSortingPrefix;
    @Value(value="${n2o.engine.graphql.sorting-suffix:}")
    private String defaultSortingSuffix;
    @Value(value="${n2o.engine.graphql.data-over-errors:false}")
    private boolean dataOverErrors;
    private RestTemplate restTemplate;
    private ObjectMapper mapper;

    public GraphQlDataProviderEngine(RestTemplate restTemplate, ObjectMapper mapper) {
        this.restTemplate = restTemplate;
        this.mapper = mapper;
    }

    public Class<? extends N2oGraphQlDataProvider> getType() {
        return N2oGraphQlDataProvider.class;
    }

    public DataSet invoke(N2oGraphQlDataProvider invocation, Map<String, Object> data) {
        return this.execute(invocation, this.prepareQuery(invocation, data), data);
    }

    private DataSet execute(N2oGraphQlDataProvider invocation, String query, Map<String, Object> data) {
        Map<String, Object> payload = this.initPayload(invocation, query, data);
        String endpoint = this.initEndpoint(invocation.getEndpoint());
        HttpHeaders headers = new HttpHeaders();
        QueryUtil.copyForwardedHeaders(this.resolveForwardedHeaders(invocation), (HttpHeaders)headers);
        QueryUtil.copyForwardedCookies(this.resolveForwardedCookies(invocation), (HttpHeaders)headers);
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addAuthorization(invocation, headers);
        HttpEntity entity = new HttpEntity(payload, (MultiValueMap)headers);
        try {
            DataSet result = (DataSet)this.restTemplate.postForObject(endpoint, (Object)entity, DataSet.class, new Object[0]);
            this.checkErrors(result, query);
            return result;
        }
        catch (RestClientResponseException e) {
            try {
                this.checkErrors((DataSet)this.mapper.readValue(e.getResponseBodyAsString(), DataSet.class), query);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            throw e;
        }
    }

    private void checkErrors(DataSet response, String query) {
        if (response.containsKey((Object)RESPONSE_ERROR_KEY)) {
            Object data = response.get((Object)RESPONSE_DATA_KEY);
            if (data != null && !((DataSet)data).isEmpty() && this.dataOverErrors) {
                return;
            }
            log.error("Execution error with GraphQL query: " + query);
            throw new N2oGraphQlException(((DataSet)response.getList(RESPONSE_ERROR_KEY).get(0)).getString(RESPONSE_ERROR_MESSAGE_KEY), query, response);
        }
    }

    private Set<String> resolveForwardedHeaders(N2oGraphQlDataProvider invocation) {
        String headers = invocation.getForwardedHeaders() != null ? invocation.getForwardedHeaders() : this.forwardHeaders;
        return QueryUtil.parseHeadersString((String)headers);
    }

    private Set<String> resolveForwardedCookies(N2oGraphQlDataProvider invocation) {
        String cookies = invocation.getForwardedCookies() != null ? invocation.getForwardedCookies() : this.forwardCookies;
        return QueryUtil.parseHeadersString((String)cookies);
    }

    private void addAuthorization(N2oGraphQlDataProvider invocation, HttpHeaders headers) {
        String token = invocation.getAccessToken() != null ? invocation.getAccessToken() : this.accessToken;
        headers.set("Authorization", "Bearer " + token);
    }

    private String prepareQuery(N2oGraphQlDataProvider invocation, Map<String, Object> data) {
        if (invocation.getQuery() == null) {
            throw new N2oException("\u0421\u0442\u0440\u043e\u043a\u0430 GraphQl \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430");
        }
        return this.resolvePlaceholders(invocation, data);
    }

    private Map<String, Object> initPayload(N2oGraphQlDataProvider invocation, String query, Map<String, Object> data) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("query", query);
        payload.put("variables", this.initVariables(invocation, query, data));
        return payload;
    }

    private String resolvePlaceholders(N2oGraphQlDataProvider invocation, Map<String, Object> data) {
        String suffix;
        String prefix;
        String query = invocation.getQuery();
        HashMap<String, Object> args = new HashMap<String, Object>(data);
        this.resolveHierarchicalSelect(args);
        query = QueryUtil.replaceListPlaceholder((String)query, (String)"$$select", args.remove("select"), (String)"", QueryUtil::reduceSpace);
        if (args.get("sorting") != null) {
            prefix = Objects.requireNonNullElse(invocation.getSortingPrefix(), this.defaultSortingPrefix);
            suffix = Objects.requireNonNullElse(invocation.getSortingSuffix(), this.defaultSortingSuffix);
            args.put("sorting", QueryUtil.insertPrefixSuffix((List)((List)args.get("sorting")), (String)prefix, (String)suffix));
            String sortingSeparator = Objects.requireNonNullElse(invocation.getSortingSeparator(), this.defaultSortingSeparator);
            query = QueryUtil.replaceListPlaceholder((String)query, (String)"$$sorting", args.remove("sorting"), (String)"", (a, b) -> QueryUtil.reduceSeparator((String)a, (String)b, (String)sortingSeparator));
        }
        if (invocation.getPageMapping() == null) {
            query = QueryUtil.replacePlaceholder((String)query, (String)"$$page", args.remove("page"), (String)"1");
        }
        if (invocation.getSizeMapping() == null) {
            query = QueryUtil.replacePlaceholder((String)query, (String)"$$size", args.remove("limit"), (String)"10");
        }
        query = QueryUtil.replacePlaceholder((String)query, (String)"$$offset", args.remove("offset"), (String)"0");
        if (args.get("filters") != null) {
            prefix = Objects.requireNonNullElse(invocation.getFilterPrefix(), this.defaultFilterPrefix);
            suffix = Objects.requireNonNullElse(invocation.getFilterSuffix(), this.defaultFilterSuffix);
            args.put("filters", QueryUtil.insertPrefixSuffix((List)((List)args.get("filters")), (String)prefix, (String)suffix));
            String filterSeparator = Objects.requireNonNullElse(invocation.getFilterSeparator(), this.defaultFilterSeparator);
            query = QueryUtil.replaceListPlaceholder((String)query, (String)"$$filters", args.remove("filters"), (String)"", (a, b) -> QueryUtil.reduceSeparator((String)a, (String)b, (String)filterSeparator));
        }
        Set<String> placeholderKeys = this.extractPlaceholderKeys(query);
        Set<String> escapeStringPlaceholders = this.extractEscapeStringPlaceholder(query);
        for (Map.Entry entry : args.entrySet()) {
            String value;
            String placeholder = "$$".concat((String)entry.getKey());
            if (escapeStringPlaceholders.contains(entry.getKey())) {
                placeholder = "$".concat(placeholder);
                value = GraphQlUtil.escapeJson(GraphQlUtil.toGraphQlString(entry.getValue()));
            } else {
                value = placeholderKeys.contains(entry.getKey()) || ArrayUtils.contains((Object[])invocation.getEnums(), entry.getKey()) ? (String)entry.getValue() : GraphQlUtil.toGraphQlString(entry.getValue());
            }
            query = QueryUtil.replacePlaceholder((String)query, (String)placeholder, (Object)value, (String)"null");
        }
        log.debug("Execute GraphQL query: " + query);
        return query;
    }

    private void resolveHierarchicalSelect(Map<String, Object> args) {
        List selectExpressions = (List)args.get("select");
        if (selectExpressions == null) {
            return;
        }
        ArrayList<String> resolvedExpressions = new ArrayList<String>();
        for (String selectExpression : selectExpressions) {
            while (this.selectKeyPattern.matcher(selectExpression).find()) {
                selectExpression = this.resolveSelectKey(selectExpression, args);
            }
            resolvedExpressions.add(selectExpression);
        }
        args.put("select", resolvedExpressions);
    }

    private String resolveSelectKey(String selectExpression, Map<String, Object> args) {
        Set<String> selectKeys = this.extract(selectExpression, this.selectKeyPattern, (s, m) -> s.substring(m.start() + 2, m.end() - 1));
        Optional selectKey = selectKeys.stream().findFirst();
        if (selectKey.isEmpty()) {
            return selectExpression;
        }
        if (selectKeys.size() > 1) {
            throw new N2oException("Find more than one select key in expression " + selectExpression);
        }
        List value = (List)args.remove(selectKey.get());
        if (value == null) {
            throw new N2oException(String.format("Value for placeholder %s not found ", "$$" + (String)selectKey.get()));
        }
        return QueryUtil.replacePlaceholder((String)selectExpression, (String)("$$" + (String)selectKey.get()), (Object)String.join((CharSequence)" ", value), (String)"");
    }

    private Object initVariables(N2oGraphQlDataProvider invocation, String query, Map<String, Object> data) {
        Set<String> variables = this.extractVariables(query);
        DataSet result = new DataSet();
        if (invocation.getPageMapping() != null) {
            data.put(invocation.getPageMapping(), data.get("page"));
        }
        if (invocation.getSizeMapping() != null) {
            data.put(invocation.getSizeMapping(), data.get("limit"));
        }
        for (String variable : variables) {
            if (!data.containsKey(variable)) continue;
            result.add(variable, data.get(variable));
        }
        return result;
    }

    private Set<String> extractVariables(String query) {
        return this.extract(query, this.variablePattern, (s, m) -> s.substring(m.start() + 1, m.end()));
    }

    private Set<String> extractPlaceholderKeys(String query) {
        return this.extract(query, this.placeholderKeyPattern, (s, m) -> s.substring(m.start() + 2, m.end() - 1).trim());
    }

    private Set<String> extractEscapeStringPlaceholder(String query) {
        return this.extract(query, this.placeholderStringEscapePattern, (s, m) -> s.substring(m.start() + 3, m.end()));
    }

    private Set<String> extract(String query, Pattern pattern, BiFunction<String, Matcher, String> function) {
        HashSet<String> result = new HashSet<String>();
        Matcher matcher = pattern.matcher(query);
        while (matcher.find()) {
            result.add(function.apply(query, matcher));
        }
        return result;
    }

    private String initEndpoint(String invocationEndpoint) {
        return invocationEndpoint != null ? invocationEndpoint : this.endpoint;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

