/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.boot;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolverChain;

public class SPAResolver
implements ResourceResolver {
    private Resource index = new ClassPathResource("META-INF/resources/index.html");
    private List<String> ignoredPaths = Arrays.asList("n2o", "api", "rest", "docs");

    public Resource resolveResource(HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return this.resolve(requestPath, locations);
    }

    public String resolveUrlPath(String resourcePath, List<? extends Resource> locations, ResourceResolverChain chain) {
        Resource resolvedResource = this.resolve(resourcePath, locations);
        if (resolvedResource == null) {
            return null;
        }
        try {
            return resolvedResource.getURL().toString();
        }
        catch (IOException e) {
            return resolvedResource.getFilename();
        }
    }

    private Resource resolve(String requestPath, List<? extends Resource> locations) {
        if (this.isIgnored(requestPath)) {
            return null;
        }
        if (this.isHandled(requestPath)) {
            return new ClassPathResource("META-INF/resources/" + this.getStaticPath(requestPath));
        }
        return this.index;
    }

    private String getStaticPath(String requestPath) {
        int index = requestPath.indexOf("static/");
        return requestPath.substring(index);
    }

    private boolean isIgnored(String path) {
        for (String ignoredPath : this.ignoredPaths) {
            if (!path.startsWith(ignoredPath)) continue;
            return true;
        }
        return false;
    }

    private boolean isHandled(String path) {
        String extension = StringUtils.getFilenameExtension((String)path);
        return path.contains("static/") && extension != null;
    }
}

