/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.boot;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import javax.annotation.PreDestroy;
import net.n2oapp.framework.boot.ObjectMapperConstructor;
import net.n2oapp.framework.boot.mongodb.MongoDbDataProviderEngine;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MongoClient.class})
public class N2oMongoAutoConfiguration {
    @Value(value="${n2o.engine.mongodb.connection_url:}")
    private String connectionUrl;
    @Deprecated
    private MongoClient mongo;

    @Bean
    @ConditionalOnMissingBean
    public MongoDbDataProviderEngine mongoDbDataProviderEngine() {
        return new MongoDbDataProviderEngine(ObjectMapperConstructor.dataObjectMapper());
    }

    @PreDestroy
    public void close() {
        if (this.mongo != null) {
            this.mongo.close();
        }
    }

    @Deprecated
    @Bean
    @ConditionalOnProperty(value={"n2o.engine.mongodb.connection_url"})
    public MongoClient mongo() {
        ConnectionString connectionString = new ConnectionString(this.connectionUrl);
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(connectionString).build();
        this.mongo = MongoClients.create((MongoClientSettings)mongoClientSettings);
        return this.mongo;
    }
}

