/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.n2oapp.engine.factory.integration.spring.OverrideBean;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.event.N2oEventBus;
import net.n2oapp.framework.api.metadata.pipeline.ReadCompileTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadTerminalPipeline;
import net.n2oapp.framework.api.metadata.reader.ConfigMetadataLocker;
import net.n2oapp.framework.api.pack.MetadataPack;
import net.n2oapp.framework.api.register.route.MetadataRouter;
import net.n2oapp.framework.boot.N2oEnvironmentConfiguration;
import net.n2oapp.framework.boot.ObjectMapperConstructor;
import net.n2oapp.framework.config.ConfigStarter;
import net.n2oapp.framework.config.N2oApplicationBuilder;
import net.n2oapp.framework.config.compile.pipeline.N2oPipelineSupport;
import net.n2oapp.framework.config.persister.MetadataPersister;
import net.n2oapp.framework.config.reader.ConfigMetadataLockerImpl;
import net.n2oapp.framework.config.reader.util.N2oJdomTextProcessing;
import net.n2oapp.framework.config.register.route.N2oRouter;
import net.n2oapp.framework.config.register.scanner.XmlInfoScanner;
import net.n2oapp.framework.config.register.storage.PathUtil;
import net.n2oapp.framework.config.warmup.HeaderWarmUpper;
import net.n2oapp.properties.io.PropertiesInfoCollector;
import net.n2oapp.watchdir.WatchDir;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

@Configuration
@EnableCaching
@Import(value={N2oEnvironmentConfiguration.class})
public class N2oMetadataConfiguration {
    @Value(value="${n2o.config.path}")
    private String configPath;
    @Value(value="${n2o.project.path:}")
    private List<String> projectPaths;
    @Value(value="${n2o.config.readonly}")
    private boolean readonly;
    @Value(value="${n2o.config.ignores}")
    private List<String> ignores;

    @Bean
    @ConditionalOnMissingBean
    public ObjectMapper n2oObjectMapper() {
        return ObjectMapperConstructor.metaObjectMapper();
    }

    @Bean
    @ConditionalOnMissingBean
    public N2oEventBus n2oEventBus(ApplicationEventPublisher publisher) {
        return new N2oEventBus(publisher);
    }

    @Bean
    @ConditionalOnMissingBean
    public MetadataPersister metadataPersister() {
        return new MetadataPersister(this.readonly);
    }

    @Bean
    @ConditionalOnMissingBean
    public PropertiesInfoCollector propertiesMetaInfoCollector() {
        return new PropertiesInfoCollector("classpath*:META-INF/n2o.properties");
    }

    @Bean
    @ConditionalOnMissingBean
    public WatchDir watchDir() {
        return new WatchDir();
    }

    @Bean
    @ConditionalOnMissingBean
    public ConfigMetadataLocker configMetadataLocker() {
        return new ConfigMetadataLockerImpl(this.configPath);
    }

    @Bean
    @ConditionalOnMissingBean
    public MetadataRouter n2oRouter(MetadataEnvironment env) {
        return new N2oRouter(env, (ReadCompileTerminalPipeline)((ReadCompileTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)((ReadTerminalPipeline)N2oPipelineSupport.readPipeline((MetadataEnvironment)env).read()).transform()).validate()).cache()).copy()).compile()).transform());
    }

    @Bean
    @ConditionalOnMissingBean
    public N2oJdomTextProcessing n2oJdomTextProcessing(@Qualifier(value="n2oMessageSourceAccessor") MessageSourceAccessor n2oMessageSourceAccessor, ConfigurableEnvironment environment) {
        return new N2oJdomTextProcessing(n2oMessageSourceAccessor, (PropertyResolver)environment);
    }

    @Bean
    @ConditionalOnMissingBean
    public N2oApplicationBuilder n2oApplicationBuilder(MetadataEnvironment n2oEnvironment, Optional<Map<String, MetadataPack<? super N2oApplicationBuilder>>> beans) {
        N2oApplicationBuilder applicationBuilder = new N2oApplicationBuilder(n2oEnvironment);
        Map packs = OverrideBean.removeOverriddenBeans(beans.orElse(Collections.emptyMap()));
        applicationBuilder.packs(packs.values().toArray(new MetadataPack[packs.values().size()]));
        applicationBuilder.scanComponentTypes("net.n2oapp.framework");
        return applicationBuilder;
    }

    @Bean(destroyMethod="stop")
    @ConditionalOnMissingBean
    public ConfigStarter configStarter(N2oEventBus eventBus, ConfigMetadataLocker locker, WatchDir watchDir, N2oApplicationBuilder applicationBuilder, XmlInfoScanner xmlInfoScanner) {
        Set configPaths = PathUtil.getConfigPaths((String)this.configPath, this.projectPaths, (String)xmlInfoScanner.getPattern(), this.ignores);
        return new ConfigStarter(applicationBuilder, eventBus, locker, watchDir, (Collection)configPaths);
    }

    @Bean
    @ConditionalOnMissingBean
    public HeaderWarmUpper headerWarmUpper(N2oApplicationBuilder applicationBuilder, Environment environment) {
        HeaderWarmUpper headerWarmUpper = new HeaderWarmUpper();
        headerWarmUpper.setEnvironment(environment);
        headerWarmUpper.setApplicationBuilder(applicationBuilder);
        return headerWarmUpper;
    }
}

