/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.data.CriteriaConstructor;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.data.InvocationProcessor;
import net.n2oapp.framework.api.data.OperationExceptionHandler;
import net.n2oapp.framework.api.data.QueryExceptionHandler;
import net.n2oapp.framework.api.data.QueryProcessor;
import net.n2oapp.framework.api.rest.RestLoggingHandler;
import net.n2oapp.framework.api.ui.AlertMessageBuilder;
import net.n2oapp.framework.api.util.ExternalFilesLoader;
import net.n2oapp.framework.api.util.SubModelsProcessor;
import net.n2oapp.framework.boot.ObjectMapperConstructor;
import net.n2oapp.framework.boot.graphql.GraphQlDataProviderEngine;
import net.n2oapp.framework.config.util.N2oExternalFilesLoader;
import net.n2oapp.framework.config.util.N2oSubModelsProcessor;
import net.n2oapp.framework.engine.SpringApplicationContextProvider;
import net.n2oapp.framework.engine.data.N2oCriteriaConstructor;
import net.n2oapp.framework.engine.data.N2oInvocationFactory;
import net.n2oapp.framework.engine.data.N2oInvocationProcessor;
import net.n2oapp.framework.engine.data.N2oOperationExceptionHandler;
import net.n2oapp.framework.engine.data.N2oOperationProcessor;
import net.n2oapp.framework.engine.data.N2oQueryExceptionHandler;
import net.n2oapp.framework.engine.data.N2oQueryProcessor;
import net.n2oapp.framework.engine.data.java.JavaDataProviderEngine;
import net.n2oapp.framework.engine.data.java.ObjectLocator;
import net.n2oapp.framework.engine.data.json.TestDataProviderEngine;
import net.n2oapp.framework.engine.data.rest.N2oRestLoggingHandler;
import net.n2oapp.framework.engine.data.rest.SpringRestDataProviderEngine;
import net.n2oapp.framework.engine.modules.stack.DataProcessingStack;
import net.n2oapp.framework.engine.modules.stack.SpringDataProcessingStack;
import net.n2oapp.framework.engine.validation.N2oValidationModule;
import net.n2oapp.framework.engine.validation.engine.ValidationProcessor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriTemplateHandler;

@Configuration
@ComponentScan(basePackages={"net.n2oapp.framework.engine"}, lazyInit=true)
public class N2oEngineConfiguration {
    @Value(value="${n2o.engine.pageStartsWith0}")
    private boolean pageStartsWith0;
    @Value(value="${n2o.engine.query.asc-expression}")
    private String ascExpression;
    @Value(value="${n2o.engine.query.desc-expression}")
    private String descExpression;
    @Value(value="${n2o.engine.rest.url}")
    private String baseRestUrl;
    @Value(value="${n2o.engine.timeout}")
    private String timeoutInMillis;
    @Value(value="${n2o.config.path}")
    private String configPath;
    @Value(value="${n2o.engine.test.readonly}")
    private boolean readonly;
    @Value(value="${n2o.engine.test.classpath}")
    private String resourcePath;

    @Bean
    public SpringApplicationContextProvider applicationContextProvider() {
        return new SpringApplicationContextProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    public DataProcessingStack dataProcessingStack(ApplicationContext context) {
        SpringDataProcessingStack dataProcessingStack = new SpringDataProcessingStack();
        dataProcessingStack.setApplicationContext(context);
        return dataProcessingStack;
    }

    @Bean
    @ConditionalOnMissingBean
    public N2oInvocationFactory actionInvocationFactory(ApplicationContext context) {
        N2oInvocationFactory actionInvocationFactory = new N2oInvocationFactory();
        actionInvocationFactory.setApplicationContext(context);
        return actionInvocationFactory;
    }

    @Bean
    @ConditionalOnMissingBean
    public InvocationProcessor invocationProcessor(N2oInvocationFactory invocationFactory, MetadataEnvironment environment) {
        N2oInvocationProcessor n2oInvocationProcessor = new N2oInvocationProcessor(invocationFactory);
        n2oInvocationProcessor.setEnvironment(environment);
        return n2oInvocationProcessor;
    }

    @Bean
    public ValidationProcessor validationProcessor(InvocationProcessor invocationProcessor, DomainProcessor domainProcessor) {
        return new ValidationProcessor(invocationProcessor, domainProcessor);
    }

    @Bean
    public N2oValidationModule validationModule(ValidationProcessor processor, AlertMessageBuilder alertMessageBuilder) {
        return new N2oValidationModule(processor, alertMessageBuilder);
    }

    @Bean
    @ConditionalOnMissingBean
    public QueryProcessor queryProcessor(N2oInvocationFactory invocationFactory, QueryExceptionHandler exceptionHandler, MetadataEnvironment environment) {
        N2oQueryProcessor n2oQueryProcessor = new N2oQueryProcessor(invocationFactory, exceptionHandler);
        n2oQueryProcessor.setCriteriaConstructor((CriteriaConstructor)new N2oCriteriaConstructor(this.pageStartsWith0));
        n2oQueryProcessor.setPageStartsWith0(this.pageStartsWith0);
        n2oQueryProcessor.setAscExpression(this.ascExpression);
        n2oQueryProcessor.setDescExpression(this.descExpression);
        n2oQueryProcessor.setEnvironment(environment);
        return n2oQueryProcessor;
    }

    @Bean
    @ConditionalOnMissingBean
    public SubModelsProcessor subModelsProcessor(QueryProcessor queryProcessor, MetadataEnvironment environment, DomainProcessor domainProcessor) {
        N2oSubModelsProcessor n2oSubModelsProcessor = new N2oSubModelsProcessor(queryProcessor, domainProcessor);
        n2oSubModelsProcessor.setEnvironment(environment);
        return n2oSubModelsProcessor;
    }

    @Bean
    @ConditionalOnMissingBean
    public OperationExceptionHandler operationExceptionHandler() {
        return new N2oOperationExceptionHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public QueryExceptionHandler queryExceptionHandler() {
        return new N2oQueryExceptionHandler();
    }

    @Bean
    public N2oOperationProcessor actionProcessor(InvocationProcessor invocationProcessor, OperationExceptionHandler operationExceptionHandler) {
        return new N2oOperationProcessor(invocationProcessor, operationExceptionHandler);
    }

    @Bean
    public JavaDataProviderEngine javaDataProviderEngine(Optional<List<ObjectLocator>> locators) {
        JavaDataProviderEngine javaDataProviderEngine = new JavaDataProviderEngine();
        javaDataProviderEngine.setLocators(locators.orElse(Collections.emptyList()));
        return javaDataProviderEngine;
    }

    @Bean
    @ConditionalOnMissingBean
    public TestDataProviderEngine testDataProviderEngine() {
        TestDataProviderEngine testDataProviderEngine = new TestDataProviderEngine();
        testDataProviderEngine.setPathOnDisk(this.configPath);
        testDataProviderEngine.setClasspathResourcePath(this.resourcePath);
        testDataProviderEngine.setReadonly(this.readonly);
        return testDataProviderEngine;
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQlDataProviderEngine graphQlDataProviderEngine() {
        RestTemplate restTemplate = new RestTemplate();
        ObjectMapper mapper = new ObjectMapper();
        return new GraphQlDataProviderEngine(restTemplate, mapper);
    }

    @Bean
    @ConditionalOnMissingBean
    public ExternalFilesLoader externalFilesLoader() {
        return new N2oExternalFilesLoader();
    }

    @Bean
    @ConditionalOnMissingBean(name={"restDataProviderEngine"})
    public SpringRestDataProviderEngine restDataProviderEngine(@Qualifier(value="restProviderRestTemplate") RestTemplate restTemplate, List<RestLoggingHandler> loggingHandlers) {
        SpringRestDataProviderEngine springRestDataProviderEngine = new SpringRestDataProviderEngine(restTemplate, ObjectMapperConstructor.dataObjectMapper(), loggingHandlers);
        springRestDataProviderEngine.setBaseRestUrl(this.baseRestUrl);
        return springRestDataProviderEngine;
    }

    @Bean
    @ConditionalOnMissingBean
    public RestLoggingHandler loggingHandler() {
        return new N2oRestLoggingHandler();
    }

    @Bean
    @ConditionalOnMissingBean(name={"restProviderRestTemplate"})
    public RestTemplate restProviderRestTemplate(RestTemplateBuilder builder) {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setObjectMapper(ObjectMapperConstructor.dataObjectMapper());
        DefaultUriBuilderFactory builderFactory = new DefaultUriBuilderFactory();
        builderFactory.setEncodingMode(DefaultUriBuilderFactory.EncodingMode.TEMPLATE_AND_VALUES);
        RestTemplate restTemplate = builder.messageConverters(new HttpMessageConverter[]{converter}).build();
        restTemplate.setUriTemplateHandler((UriTemplateHandler)builderFactory);
        return restTemplate;
    }
}

