/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.ui;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.data.exception.N2oQueryExecutionException;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.exception.N2oUserException;
import net.n2oapp.framework.api.exception.N2oValidationException;
import net.n2oapp.framework.api.exception.SeverityType;
import net.n2oapp.framework.api.exception.ValidationMessage;
import net.n2oapp.framework.api.metadata.meta.widget.MessagePlacement;
import net.n2oapp.framework.api.ui.ActionRequestInfo;
import net.n2oapp.framework.api.ui.RequestInfo;
import net.n2oapp.framework.api.ui.ResponseMessage;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.env.PropertyResolver;

public class AlertMessageBuilder {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private MessageSourceAccessor messageSourceAccessor;
    private PropertyResolver propertyResolver;
    private boolean showStacktrace = true;
    private boolean devMode;

    public AlertMessageBuilder(MessageSourceAccessor messageSourceAccessor, PropertyResolver propertyResolver) {
        this.messageSourceAccessor = messageSourceAccessor;
        this.propertyResolver = propertyResolver;
    }

    public AlertMessageBuilder(MessageSourceAccessor messageSourceAccessor, PropertyResolver propertyResolver, boolean showStacktrace) {
        this.messageSourceAccessor = messageSourceAccessor;
        this.propertyResolver = propertyResolver;
        this.showStacktrace = showStacktrace;
    }

    public ResponseMessage build(Exception e) {
        ResponseMessage resp = this.constructMessage(this.getExceptionSeverity(e));
        return this.prepareMessage(e, resp);
    }

    public ResponseMessage build(Exception e, RequestInfo requestInfo) {
        ResponseMessage resp = this.buildMessage(requestInfo, this.getExceptionSeverity(e));
        return this.prepareMessage(e, resp);
    }

    public ResponseMessage buildMessage(RequestInfo requestInfo, SeverityType severityType) {
        ResponseMessage message = this.constructMessage(severityType);
        if (requestInfo.getMessagePlacement() != null) {
            message.setPlacement(MessagePlacement.valueOf(requestInfo.getMessagePlacement().name()));
        }
        return message;
    }

    public List<ResponseMessage> buildMessages(Exception e, RequestInfo requestInfo) {
        return e instanceof N2oValidationException ? this.buildValidationMessages((N2oValidationException)e, requestInfo) : Collections.singletonList(this.build(e, requestInfo));
    }

    public ResponseMessage buildSuccessMessage(ActionRequestInfo<DataSet> requestInfo, DataSet data) {
        ResponseMessage message = this.buildMessage(requestInfo, SeverityType.success);
        message.setText(StringUtils.resolveLinks(requestInfo.getOperation().getSuccessText(), data));
        message.setTitle(StringUtils.resolveLinks(requestInfo.getOperation().getSuccessTitle(), data));
        return message;
    }

    private void initDevMode(PropertyResolver propertyResolver) {
        Boolean activeDevMode = propertyResolver != null ? (Boolean)propertyResolver.getProperty("n2o.ui.message.dev-mode", Boolean.class) : null;
        this.devMode = activeDevMode != null && activeDevMode != false;
    }

    private SeverityType getExceptionSeverity(Exception e) {
        return e instanceof N2oException ? ((N2oException)e).getSeverity() : SeverityType.danger;
    }

    private ResponseMessage prepareMessage(Exception e, ResponseMessage resp) {
        this.initDevMode(this.propertyResolver);
        resp.setText(this.buildText(e));
        if (!this.devMode && e instanceof N2oException && ((N2oException)e).getUserMessageTitle() != null) {
            resp.setTitle(((N2oException)e).getUserMessageTitle());
        }
        if (this.showStacktrace && !(e instanceof N2oUserException)) {
            resp.setPayload(this.initPayload(e));
        }
        if (e instanceof N2oException) {
            resp.setField(((N2oException)e).getField());
        }
        return resp;
    }

    private List<String> initPayload(Exception e) {
        if (this.devMode && e instanceof N2oQueryExecutionException) {
            return Collections.singletonList("Executed query: " + ((N2oQueryExecutionException)e).getQuery());
        }
        return this.getStackFrames(this.getStackTrace(e));
    }

    private ResponseMessage constructMessage(SeverityType severityType) {
        ResponseMessage message = new ResponseMessage();
        message.setSeverityType(severityType);
        if (this.propertyResolver != null) {
            message.setPlacement((MessagePlacement)((Object)this.propertyResolver.getProperty("n2o.api.message.placement", MessagePlacement.class)));
            if (severityType != null) {
                Integer timeout = Integer.parseInt(this.propertyResolver.getProperty(String.format("n2o.api.message.%s.timeout", severityType.getId())));
                message.setTimeout(timeout);
            }
        }
        return message;
    }

    public List<ResponseMessage> buildValidationMessages(N2oValidationException e, RequestInfo requestInfo) {
        ArrayList<ResponseMessage> messages = new ArrayList<ResponseMessage>();
        if (e.getMessages() != null) {
            for (ValidationMessage message : e.getMessages()) {
                ResponseMessage resp = this.buildMessage(requestInfo, e.getSeverity());
                resp.setField(message.getFieldId());
                resp.setText(message.getMessage());
                resp.setTitle(message.getMessageTitle());
                messages.add(resp);
            }
        }
        return messages;
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    private List<String> getStackFrames(String stacktrace) {
        StringTokenizer frames = new StringTokenizer(stacktrace, LINE_SEPARATOR);
        ArrayList<String> list = new ArrayList<String>();
        while (frames.hasMoreTokens()) {
            list.add(frames.nextToken());
        }
        return list;
    }

    private String buildText(Exception e) {
        String message = "n2o.exceptions.error.message";
        String userMessage = this.initUserMessage(e);
        message = userMessage != null ? userMessage : message;
        String localizedMessage = this.messageSourceAccessor.getMessage(message, message);
        if (e instanceof N2oException) {
            return StringUtils.resolveLinks(localizedMessage, ((N2oException)e).getData());
        }
        return localizedMessage;
    }

    private String initUserMessage(Exception e) {
        if (this.devMode && !(e instanceof N2oUserException)) {
            return e.getMessage();
        }
        if (e instanceof N2oException) {
            return ((N2oException)e).getUserMessage();
        }
        return null;
    }
}

