/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.rest;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.n2oapp.framework.api.metadata.meta.page.Dialog;
import net.n2oapp.framework.api.metadata.meta.saga.AlertSaga;
import net.n2oapp.framework.api.metadata.meta.saga.LoadingSaga;
import net.n2oapp.framework.api.metadata.meta.saga.MessageSaga;
import net.n2oapp.framework.api.metadata.meta.saga.MetaSaga;
import net.n2oapp.framework.api.metadata.meta.saga.PollingSaga;
import net.n2oapp.framework.api.metadata.meta.saga.RedirectSaga;
import net.n2oapp.framework.api.metadata.meta.saga.RefreshSaga;
import net.n2oapp.framework.api.ui.ResponseMessage;

public class N2oResponse {
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private MetaSaga meta;
    @JsonIgnore
    private int status = 200;

    public N2oResponse() {
    }

    public N2oResponse(List<ResponseMessage> messages, String widgetId) {
        this.addResponseMessages(messages, widgetId);
    }

    public void addResponseMessages(List<ResponseMessage> messageList, String widgetId) {
        if (messageList == null || messageList.isEmpty()) {
            return;
        }
        messageList.forEach(m -> this.addResponseMessage((ResponseMessage)m, widgetId));
    }

    public void addResponseMessage(ResponseMessage message, String widgetId) {
        if (message == null) {
            return;
        }
        if (this.getMeta() == null) {
            this.setMeta(new MetaSaga());
        }
        if (message.getField() == null) {
            if (this.getMeta().getAlert() == null) {
                this.getMeta().setAlert(new AlertSaga());
            }
            if (this.getMeta().getAlert().getMessages() == null) {
                this.getMeta().getAlert().setMessages(new ArrayList<ResponseMessage>());
            }
            this.getMeta().getAlert().getMessages().add(message);
            this.getMeta().getAlert().setAlertKey(widgetId);
        } else {
            if (this.getMeta().getMessages() == null) {
                MessageSaga messages = new MessageSaga();
                messages.setForm(widgetId);
                this.getMeta().setMessages(messages);
            }
            if (this.getMeta().getMessages().getFields() == null) {
                this.getMeta().getMessages().setFields(new HashMap<String, ResponseMessage>());
            }
            this.getMeta().getMessages().getFields().putIfAbsent(message.getField(), message);
        }
    }

    public void setResponseMessages(List<ResponseMessage> messageList, String widgetId) {
        if (this.getMeta() == null) {
            this.setMeta(new MetaSaga());
        }
        this.getMeta().setMessages(null);
        if (messageList == null || messageList.isEmpty()) {
            return;
        }
        if (messageList.stream().anyMatch(m -> m.getField() == null)) {
            this.getMeta().setAlert(new AlertSaga());
        }
        messageList.forEach(m -> this.addResponseMessage((ResponseMessage)m, widgetId));
    }

    public void setDialog(Dialog dialog) {
        this.safeGetMeta().setDialog(dialog);
    }

    public void addRedirect(RedirectSaga redirect) {
        this.safeGetMeta().setRedirect(redirect);
    }

    public void addPolling(PollingSaga polling) {
        this.safeGetMeta().setPolling(polling);
    }

    public void addRefresh(RefreshSaga refresh) {
        this.safeGetMeta().setRefresh(refresh);
    }

    public void addLoading(LoadingSaga loading) {
        this.safeGetMeta().setLoading(loading);
    }

    public void addClear(String clearDatasource) {
        this.safeGetMeta().setClear(clearDatasource);
    }

    private MetaSaga safeGetMeta() {
        if (this.getMeta() == null) {
            this.setMeta(new MetaSaga());
        }
        return this.getMeta();
    }

    public MetaSaga getMeta() {
        return this.meta;
    }

    public int getStatus() {
        return this.status;
    }

    @JsonProperty
    public void setMeta(MetaSaga meta) {
        this.meta = meta;
    }

    @JsonIgnore
    public void setStatus(int status) {
        this.status = status;
    }
}

