/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.register.route;

import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.compile.CompileContext;

public class RouteInfo
implements Comparable<RouteInfo> {
    private String urlPattern;
    private String urlMatching;
    private CompileContext<? extends Compiled, ?> context;

    public RouteInfo(String urlPattern, CompileContext<? extends Compiled, ?> context) {
        this.setContext(context);
        this.setUrlPattern(urlPattern);
    }

    public CompileContext<? extends Compiled, ?> getContext() {
        return this.context;
    }

    public void setContext(CompileContext<? extends Compiled, ?> context) {
        this.context = context;
    }

    public void setUrlPattern(String urlPattern) {
        StringBuilder urlMatching;
        this.urlPattern = urlPattern;
        String[] splited = urlPattern.split("/");
        if (splited.length > 0) {
            urlMatching = new StringBuilder(splited[0]);
            for (int i = 1; i < splited.length; ++i) {
                if (splited[i].startsWith(":")) {
                    urlMatching.append("/").append("*");
                    continue;
                }
                urlMatching.append("/").append(splited[i]);
            }
        } else {
            urlMatching = new StringBuilder(urlPattern);
        }
        this.urlMatching = urlMatching.toString();
    }

    public String getUrlMatching() {
        return this.urlMatching;
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    @Override
    public int compareTo(RouteInfo routeInfo) {
        String[] splitUrl = this.urlMatching.split("/");
        String[] splitUrl2 = routeInfo.urlMatching.split("/");
        int res = 0;
        for (int i = 0; i < splitUrl.length && i < splitUrl2.length; ++i) {
            res = splitUrl[i].compareTo(splitUrl2[i]);
            if (res == 0) continue;
            return res > 0 ? -1 : 1;
        }
        if (res == 0 && splitUrl.length != splitUrl2.length) {
            return splitUrl.length < splitUrl2.length ? 1 : -1;
        }
        if (this.context.getCompiledClass().equals(routeInfo.getContext().getCompiledClass())) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteInfo info = (RouteInfo)o;
        if (!this.urlMatching.equals(info.urlMatching)) {
            return false;
        }
        return this.context.getCompiledClass().equals(info.context.getCompiledClass());
    }

    public int hashCode() {
        int result = this.urlMatching.hashCode();
        result = 31 * result + this.context.getCompiledClass().hashCode();
        return result;
    }

    public String toString() {
        return this.getUrlPattern() + " -> " + String.valueOf(this.getContext());
    }
}

