/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.reader;

import java.util.Objects;
import net.n2oapp.framework.api.metadata.aware.NamespaceUriAware;
import net.n2oapp.framework.api.metadata.reader.CurrentElementHolder;
import net.n2oapp.framework.api.metadata.reader.ElementReaderFactory;
import net.n2oapp.framework.api.metadata.reader.NamespaceReader;
import net.n2oapp.framework.api.metadata.reader.TypedElementReader;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.springframework.util.StringUtils;

public interface NamespaceReaderFactory<T extends NamespaceUriAware, R extends NamespaceReader<? extends T>>
extends ElementReaderFactory<T, R> {
    public R produce(String var1, Namespace ... var2);

    @Override
    default public R produce(Element element) {
        CurrentElementHolder.setElement(element);
        try {
            R r = this.produce(element.getName(), element.getNamespace());
            return r;
        }
        finally {
            CurrentElementHolder.clearElementScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public R produce(Element element, Namespace parentNamespace, Namespace ... defaultNamespaces) {
        String parentNameSpacePrefix = Objects.nonNull(element.getParentElement()) ? element.getParentElement().getNamespacePrefix() : null;
        try {
            if (defaultNamespaces != null && (StringUtils.hasText((String)parentNameSpacePrefix) || element.getNamespace().getURI().equals(parentNamespace.getURI()))) {
                CurrentElementHolder.setElement(element);
                R r = this.produce(element.getName(), defaultNamespaces);
                return r;
            }
            TypedElementReader typedElementReader = this.produce(element);
            return (R)typedElementReader;
        }
        finally {
            CurrentElementHolder.clearElementScope();
        }
    }

    public void add(NamespaceReader<T> var1);
}

