/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.meta.badge;

import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.widget.table.ShapeType;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;
import net.n2oapp.framework.api.metadata.meta.badge.Badge;
import net.n2oapp.framework.api.metadata.meta.badge.BadgeAware;
import net.n2oapp.framework.api.metadata.meta.badge.Position;

public class BadgeUtil {
    public static final String POSITION = ".badge.position";
    public static final String SHAPE = ".badge.shape";
    public static final String IMAGE_POSITION = ".badge.image_position";
    public static final String IMAGE_SHAPE = ".badge.image_shape";

    private BadgeUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static Badge compileSimpleBadge(BadgeAware source, String propertyPrefix, CompileProcessor p) {
        if (source.getBadge() == null && source.getBadgeColor() == null && source.getBadgeImage() == null) {
            return null;
        }
        Badge badge = new Badge();
        badge.setText(p.resolveJS(source.getBadge()));
        badge.setImage(p.resolveJS(source.getBadgeImage()));
        badge.setColor(p.resolveJS(source.getBadgeColor()));
        BadgeUtil.setDefaults(badge, source, propertyPrefix, p);
        return badge;
    }

    public static void bindSimpleBadge(Badge badge, BindProcessor p) {
        if (badge != null) {
            badge.setText(p.resolve(badge.getText(), String.class));
            badge.setColor(p.resolve(badge.getColor(), String.class));
            badge.setImage(p.resolve(badge.getImage(), String.class));
        }
    }

    public static Badge compileReferringBadge(BadgeAware source, String propertyPrefix, CompileProcessor p) {
        if (source.getBadgeFieldId() == null && source.getBadgeColorFieldId() == null && source.getBadgeImageFieldId() == null) {
            return null;
        }
        Badge badge = new Badge();
        badge.setFieldId(source.getBadgeFieldId());
        badge.setColorFieldId(source.getBadgeColorFieldId());
        badge.setImageFieldId(source.getBadgeImageFieldId());
        BadgeUtil.setDefaults(badge, source, propertyPrefix, p);
        return badge;
    }

    private static void setDefaults(Badge compiled, BadgeAware source, String propertyPrefix, CompileProcessor p) {
        compiled.setShape(CompileUtil.castDefault(source.getBadgeShape(), () -> p.resolve(Placeholders.property(propertyPrefix + SHAPE), ShapeType.class)));
        compiled.setPosition(CompileUtil.castDefault(source.getBadgePosition(), () -> p.resolve(Placeholders.property(propertyPrefix + POSITION), Position.class)));
        compiled.setImagePosition(CompileUtil.castDefault(source.getBadgeImagePosition(), () -> p.resolve(Placeholders.property(propertyPrefix + IMAGE_POSITION), Position.class)));
        compiled.setImageShape(CompileUtil.castDefault(source.getBadgeImageShape(), () -> p.resolve(Placeholders.property(propertyPrefix + IMAGE_SHAPE), ShapeType.class)));
    }
}

