/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.meta;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.local.view.widget.util.SubModelQuery;
import net.n2oapp.framework.api.metadata.meta.BindLink;

public class ModelLink
extends BindLink {
    private ReduxModel model;
    private String datasource;
    private String fieldId;
    private SubModelQuery subModelQuery;
    private String param;
    @JsonProperty
    private boolean observe = false;
    @JsonProperty
    private boolean required = false;

    public ModelLink() {
    }

    public ModelLink(Object value) {
        this.setValue(value);
    }

    public ModelLink(ModelLink link) {
        super(ModelLink.createBindLink(link.model, link.datasource, link.fieldId));
        this.model = link.model;
        this.datasource = link.datasource;
        this.fieldId = link.fieldId;
        this.setValue(link.getValue());
        this.setSubModelQuery(link.getSubModelQuery());
        this.setParam(link.getParam());
        this.setObserve(link.isObserve());
    }

    public ModelLink(ReduxModel model, String datasource) {
        super(ModelLink.createBindLink(model, datasource, null));
        this.model = model;
        this.datasource = datasource;
    }

    public ModelLink(ReduxModel model, String datasource, String fieldId) {
        super(ModelLink.createBindLink(model, datasource, fieldId));
        this.model = model;
        this.datasource = datasource;
        this.fieldId = fieldId;
    }

    public String getFieldId() {
        Object result = null;
        String fieldValue = this.getFieldValue();
        if (this.fieldId != null) {
            result = this.fieldId;
        }
        if (fieldValue != null) {
            result = result != null ? (String)result + "." + fieldValue : fieldValue;
        }
        return result;
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        if (this.isConst()) {
            this.setObserve(false);
        }
    }

    public String getFieldValue() {
        if (StringUtils.isJs(this.getValue())) {
            String js = this.getValue().toString().substring(1, this.getValue().toString().length() - 1);
            if (js.contains(".map(function(t){return t.")) {
                return js.substring(0, js.indexOf("."));
            }
            return js;
        }
        return null;
    }

    @JsonIgnore
    public ModelLink getWidgetLink() {
        if (this.getModel() == null || this.getDatasource() == null) {
            return null;
        }
        ModelLink widgetLink = new ModelLink(this.getModel(), this.getDatasource());
        if (this.getFieldId() == null || this.getFieldId().equals("id")) {
            widgetLink.setSubModelQuery(this.getSubModelQuery());
        }
        return widgetLink;
    }

    @JsonIgnore
    public ModelLink getSubModelLink() {
        if (this.subModelQuery == null) {
            return null;
        }
        return new ModelLink(this.getModel(), this.getDatasource(), this.subModelQuery.getFullName());
    }

    @Override
    public boolean equalsLink(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ModelLink that = (ModelLink)o;
        if (this.getModel() == null || this.getDatasource() == null || that.getModel() == null || that.getDatasource() == null) {
            return false;
        }
        String thisFieldId = this.getFieldId();
        if (this.getSubModelQuery() != null) {
            thisFieldId = this.getSubModelQuery().getFullName();
        }
        String thisSubModelQueryLink = ModelLink.createBindLink(this.getModel(), this.getDatasource(), thisFieldId);
        String thatFieldId = that.getFieldId();
        if (that.getSubModelQuery() != null) {
            thatFieldId = that.getSubModelQuery().getFullName();
        }
        String thatSubModelQueryLink = ModelLink.createBindLink(that.getModel(), that.getDatasource(), thatFieldId);
        if (thisSubModelQueryLink.length() > thatSubModelQueryLink.length()) {
            return this.compareLinks(this, that, thisSubModelQueryLink, thatSubModelQueryLink);
        }
        if (thisSubModelQueryLink.length() < thatSubModelQueryLink.length()) {
            return this.compareLinks(that, this, thatSubModelQueryLink, thisSubModelQueryLink);
        }
        return thisSubModelQueryLink.equals(thatSubModelQueryLink);
    }

    private boolean compareLinks(ModelLink first, ModelLink second, String firstSubModelQueryLink, String secondSubModelQueryLink) {
        if (first.getValue() == null && second.getValue() == null || first.getValue() != null && second.getValue() != null) {
            return firstSubModelQueryLink.startsWith(secondSubModelQueryLink + ".");
        }
        return first.getBindLink().equals(second.getBindLink());
    }

    private static String createBindLink(ReduxModel model, String widgetId, String fieldId) {
        if (model == null) {
            return null;
        }
        return fieldId == null ? String.format("models.%s['%s']", model.getId(), widgetId) : String.format("models.%s['%s'].%s", model.getId(), widgetId, fieldId);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return "ModelLink{" + super.toString() + ", model=" + String.valueOf(this.model) + ", datasource='" + this.datasource + "', fieldId='" + this.fieldId + "'}";
    }

    public ReduxModel getModel() {
        return this.model;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public SubModelQuery getSubModelQuery() {
        return this.subModelQuery;
    }

    public String getParam() {
        return this.param;
    }

    public boolean isObserve() {
        return this.observe;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setSubModelQuery(SubModelQuery subModelQuery) {
        this.subModelQuery = subModelQuery;
    }

    public void setParam(String param) {
        this.param = param;
    }

    @JsonProperty
    public void setObserve(boolean observe) {
        this.observe = observe;
    }

    @JsonProperty
    public void setRequired(boolean required) {
        this.required = required;
    }
}

