/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.meta;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;

public class BindLink
implements Compiled {
    @JsonProperty(value="link")
    private String bindLink;
    @JsonProperty
    private Object value;

    public BindLink() {
    }

    public BindLink(String bindLink) {
        this.bindLink = bindLink;
    }

    public BindLink(String bindLink, Object value) {
        this.bindLink = bindLink;
        this.value = value;
    }

    public String getBindLink() {
        return this.bindLink;
    }

    public String normalizeLink() {
        if (StringUtils.isJs(this.getValue())) {
            return this.getBindLink() + "." + StringUtils.unwrapJs(this.value.toString());
        }
        return this.getBindLink();
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public boolean isConst() {
        return !this.isEmpty() && !StringUtils.isJs(this.getValue()) || this.bindLink == null;
    }

    public boolean isLink() {
        return this.getBindLink() != null || StringUtils.isJs(this.getValue());
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setFieldValue(String field) {
        this.value = Placeholders.js(field);
    }

    public boolean equalsNormalizedLink(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BindLink)) {
            return false;
        }
        BindLink link = (BindLink)o;
        if (this.getBindLink() == null || link.getBindLink() == null) {
            return false;
        }
        return Objects.equals(this.normalizeLink(), link.normalizeLink());
    }

    public boolean equalsLink(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BindLink)) {
            return false;
        }
        BindLink link = (BindLink)o;
        return Objects.equals(this.getBindLink(), link.getBindLink());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BindLink)) {
            return false;
        }
        BindLink bindLink1 = (BindLink)o;
        return Objects.equals(this.bindLink, bindLink1.bindLink) && Objects.equals(this.value, bindLink1.value);
    }

    public int hashCode() {
        return Objects.hash(this.bindLink, this.value);
    }

    public String toString() {
        return "BindLink{bindLink='" + this.bindLink + "', value=" + String.valueOf(this.value) + "}";
    }
}

