/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.local.util;

import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.util.SerializationUtils;

public class CompileUtil {
    public static String collectLinks(Set<String> strings) {
        Object res = "";
        boolean begin = true;
        for (String s : strings) {
            if (!begin) {
                res = (String)res + ",";
            }
            res = (String)res + s;
            begin = false;
        }
        return res;
    }

    @SafeVarargs
    public static <T> T[] append(T[] arr, T ... elements) {
        int N = arr.length;
        arr = Arrays.copyOf(arr, N + elements.length);
        for (int i = 0; i < elements.length; ++i) {
            arr[N + i] = elements[0];
        }
        return arr;
    }

    @SafeVarargs
    public static <T> T castDefault(T value, T defaultValue, T ... otherDefaultValues) {
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        if (otherDefaultValues != null) {
            for (T defValue : otherDefaultValues) {
                if (defValue == null) continue;
                return defValue;
            }
        }
        return null;
    }

    @SafeVarargs
    public static <T> T castDefault(T value, Supplier<T> ... defaultValueFunctions) {
        if (value != null) {
            return value;
        }
        if (defaultValueFunctions != null) {
            for (Supplier<T> func : defaultValueFunctions) {
                T v = func.get();
                if (v == null) continue;
                return v;
            }
        }
        return null;
    }

    public static <T> T copy(T cloningObject) {
        return (T)SerializationUtils.deserialize((byte[])SerializationUtils.serialize(cloningObject));
    }
}

