/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.global.view.region;

import java.util.List;
import java.util.Map;
import net.n2oapp.framework.api.metadata.RegionItem;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.SourceComponent;
import net.n2oapp.framework.api.metadata.aware.IdAware;
import net.n2oapp.framework.api.metadata.global.view.region.N2oRegion;
import net.n2oapp.framework.api.metadata.global.view.region.RoutableRegion;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;

public class N2oScrollspyRegion
extends N2oRegion
implements RoutableRegion {
    private String title;
    private String active;
    private String placement;
    private Boolean headlines;
    private String activeParam;
    private Boolean routable;
    private String maxHeight;
    private AbstractMenuItem[] menu;

    @Override
    public String getAlias() {
        return "scrollspy";
    }

    @Override
    public void collectWidgets(List<N2oWidget> result, Map<String, Integer> ids, String prefix) {
        if (this.menu != null) {
            for (AbstractMenuItem mi : this.menu) {
                mi.collectWidgets(result, ids, this.getAlias());
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getActive() {
        return this.active;
    }

    public String getPlacement() {
        return this.placement;
    }

    public Boolean getHeadlines() {
        return this.headlines;
    }

    @Override
    public String getActiveParam() {
        return this.activeParam;
    }

    @Override
    public Boolean getRoutable() {
        return this.routable;
    }

    public String getMaxHeight() {
        return this.maxHeight;
    }

    public AbstractMenuItem[] getMenu() {
        return this.menu;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setActive(String active) {
        this.active = active;
    }

    public void setPlacement(String placement) {
        this.placement = placement;
    }

    public void setHeadlines(Boolean headlines) {
        this.headlines = headlines;
    }

    public void setActiveParam(String activeParam) {
        this.activeParam = activeParam;
    }

    public void setRoutable(Boolean routable) {
        this.routable = routable;
    }

    public void setMaxHeight(String maxHeight) {
        this.maxHeight = maxHeight;
    }

    public void setMenu(AbstractMenuItem[] menu) {
        this.menu = menu;
    }

    public static abstract class AbstractMenuItem
    implements Source,
    IdAware,
    RegionItem {
        private String id;
        private String title;

        @Override
        public String getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }

        @Override
        public void setId(String id) {
            this.id = id;
        }

        public void setTitle(String title) {
            this.title = title;
        }
    }

    public static class GroupItem
    extends AbstractMenuItem {
        private Boolean headline;
        private AbstractMenuItem[] group;

        @Override
        public void collectWidgets(List<N2oWidget> result, Map<String, Integer> ids, String prefix) {
            if (this.group != null) {
                if (!ids.containsKey(prefix)) {
                    ids.put(prefix, 1);
                }
                for (AbstractMenuItem mi : this.group) {
                    mi.collectWidgets(result, ids, prefix);
                }
            }
        }

        public Boolean getHeadline() {
            return this.headline;
        }

        public AbstractMenuItem[] getGroup() {
            return this.group;
        }

        public void setHeadline(Boolean headline) {
            this.headline = headline;
        }

        public void setGroup(AbstractMenuItem[] group) {
            this.group = group;
        }
    }

    public static class SubMenuItem
    extends AbstractMenuItem {
        private AbstractMenuItem[] subMenu;

        @Override
        public void collectWidgets(List<N2oWidget> result, Map<String, Integer> ids, String prefix) {
            if (this.subMenu != null) {
                if (!ids.containsKey(prefix)) {
                    ids.put(prefix, 1);
                }
                for (AbstractMenuItem mi : this.subMenu) {
                    mi.collectWidgets(result, ids, prefix);
                }
            }
        }

        public AbstractMenuItem[] getSubMenu() {
            return this.subMenu;
        }

        public void setSubMenu(AbstractMenuItem[] subMenu) {
            this.subMenu = subMenu;
        }
    }

    public static class MenuItem
    extends AbstractMenuItem {
        private SourceComponent[] content;

        @Override
        public void collectWidgets(List<N2oWidget> result, Map<String, Integer> ids, String prefix) {
            if (this.content != null) {
                if (!ids.containsKey(prefix)) {
                    ids.put(prefix, 1);
                }
                for (SourceComponent component : this.content) {
                    if (!(component instanceof RegionItem)) continue;
                    ((RegionItem)((Object)component)).collectWidgets(result, ids, prefix);
                }
            }
        }

        public SourceComponent[] getContent() {
            return this.content;
        }

        public void setContent(SourceComponent[] content) {
            this.content = content;
        }
    }
}

