/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.global.view.page;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.n2oapp.framework.api.metadata.RegionItem;
import net.n2oapp.framework.api.metadata.SourceComponent;
import net.n2oapp.framework.api.metadata.global.view.region.N2oRegion;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;
import net.n2oapp.framework.api.metadata.meta.page.StandardPage;
import net.n2oapp.framework.api.metadata.meta.region.CompiledRegionItem;
import net.n2oapp.framework.api.metadata.meta.widget.Widget;
import org.apache.commons.collections.CollectionUtils;

public class BasePageUtil {
    public static List<Widget<?>> getCompiledWidgets(StandardPage page) {
        List regions = page.getRegions().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        return new ArrayList(BasePageUtil.getRegionWidgets(regions));
    }

    private static List<Widget<?>> getRegionWidgets(List<? extends CompiledRegionItem> items) {
        ArrayList widgets = new ArrayList();
        if (!CollectionUtils.isEmpty(items)) {
            for (CompiledRegionItem compiledRegionItem : items) {
                compiledRegionItem.collectWidgets(widgets);
            }
        }
        return widgets;
    }

    public static List<N2oWidget> collectWidgets(SourceComponent[] items) {
        ArrayList<N2oWidget> widgets = new ArrayList<N2oWidget>();
        if (items != null) {
            HashMap<String, Integer> ids = new HashMap<String, Integer>();
            for (SourceComponent item : items) {
                if (!(item instanceof RegionItem)) continue;
                ((RegionItem)((Object)item)).collectWidgets(widgets, ids, "w");
            }
        }
        return widgets;
    }

    public static void resolveRegionItems(SourceComponent[] items, Consumer<N2oRegion> regionConsumer, Consumer<N2oWidget> widgetConsumer) {
        for (SourceComponent item : items) {
            if (item instanceof N2oWidget) {
                widgetConsumer.accept((N2oWidget)item);
                continue;
            }
            if (!(item instanceof N2oRegion)) continue;
            regionConsumer.accept((N2oRegion)item);
        }
    }
}

