/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.global.dao.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.n2oapp.criteria.filters.FilterType;
import net.n2oapp.framework.api.N2oNamespace;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.aware.NameAware;
import net.n2oapp.framework.api.metadata.global.N2oMetadata;
import net.n2oapp.framework.api.metadata.global.dao.invocation.model.N2oInvocation;
import net.n2oapp.framework.api.metadata.global.dao.query.AbstractField;
import net.n2oapp.framework.api.metadata.global.dao.query.field.QueryReferenceField;
import net.n2oapp.framework.api.metadata.global.dao.query.field.QuerySimpleField;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.lang.NonNull;

public class N2oQuery
extends N2oMetadata
implements NameAware,
ExtensionAttributesAware {
    protected AbstractField[] fields;
    private String name;
    private String objectId;
    private String route;
    private Selection[] lists;
    private Selection[] uniques;
    private Selection[] counts;
    private Filter[] filters;
    private Map<String, Filter[]> filtersMap;
    private Map<N2oNamespace, Map<String, String>> extAttributes;

    @Override
    public final String getPostfix() {
        return "query";
    }

    public final Class<? extends N2oMetadata> getSourceBaseClass() {
        return N2oQuery.class;
    }

    public QuerySimpleField getSimpleFieldByAbsoluteId(@NonNull String absoluteId) {
        if (ArrayUtils.isEmpty((Object[])this.fields)) {
            return null;
        }
        if (Objects.isNull(this.fields[0].getAbsoluteId())) {
            this.initAbsoluteIds();
        }
        return this.getSimpleFields().stream().filter(f -> absoluteId.equals(f.getAbsoluteId())).findFirst().orElse(null);
    }

    public void initAbsoluteIds() {
        if (ArrayUtils.isNotEmpty((Object[])this.fields)) {
            this.initAbsoluteId(this.fields, null);
        }
    }

    public void initAbsoluteId(AbstractField[] fields, String parentId) {
        for (AbstractField field : fields) {
            String computedId = Objects.isNull(parentId) ? field.getId() : parentId + "." + field.getId();
            field.setAbsoluteId(computedId);
            if (!(field instanceof QueryReferenceField) || !ArrayUtils.isNotEmpty((Object[])((QueryReferenceField)field).getFields())) continue;
            this.initAbsoluteId(((QueryReferenceField)field).getFields(), computedId);
        }
    }

    public List<QuerySimpleField> getSimpleFields() {
        ArrayList<QuerySimpleField> result = new ArrayList<QuerySimpleField>();
        this.collectSimpleFields(this.fields, result);
        return result;
    }

    private void collectSimpleFields(AbstractField[] fields, List<QuerySimpleField> simpleFields) {
        if (Objects.isNull(fields)) {
            return;
        }
        for (AbstractField field : fields) {
            if (field instanceof QueryReferenceField) {
                this.collectSimpleFields(((QueryReferenceField)field).getFields(), simpleFields);
                continue;
            }
            simpleFields.add((QuerySimpleField)field);
        }
    }

    public boolean isSearchAvailable(String fieldId) {
        if (Objects.isNull(this.filters)) {
            return false;
        }
        return Arrays.stream(this.filters).anyMatch(filter -> fieldId.equals(filter.getFieldId()));
    }

    public Filter[] getFiltersList(String fieldId) {
        if (Objects.isNull(this.filters)) {
            return new Filter[0];
        }
        if (Objects.isNull(this.filtersMap)) {
            HashMap filtersListMap = new HashMap();
            for (Filter filter : this.filters) {
                filtersListMap.putIfAbsent(filter.getFieldId(), new ArrayList());
                ((List)filtersListMap.get(filter.getFieldId())).add(filter);
            }
            this.setFiltersMap(filtersListMap.keySet().stream().collect(Collectors.toMap(Function.identity(), k -> ((List)filtersListMap.get(k)).toArray(new Filter[0]))));
        }
        return this.filtersMap.getOrDefault(fieldId, new Filter[0]);
    }

    public void adapterV4() {
        if (Objects.nonNull(this.fields)) {
            ArrayList<Filter> filters = new ArrayList<Filter>();
            for (AbstractField field : this.fields) {
                if (!Objects.nonNull(((QuerySimpleField)field).getFilterList())) continue;
                for (Filter filter : ((QuerySimpleField)field).getFilterList()) {
                    filter.setFieldId(field.getId());
                    filters.add(filter);
                }
            }
            this.setFilters(filters.toArray(new Filter[0]));
        }
    }

    public AbstractField[] getFields() {
        return this.fields;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getRoute() {
        return this.route;
    }

    public Selection[] getLists() {
        return this.lists;
    }

    public Selection[] getUniques() {
        return this.uniques;
    }

    public Selection[] getCounts() {
        return this.counts;
    }

    public Filter[] getFilters() {
        return this.filters;
    }

    public Map<String, Filter[]> getFiltersMap() {
        return this.filtersMap;
    }

    @Override
    public Map<N2oNamespace, Map<String, String>> getExtAttributes() {
        return this.extAttributes;
    }

    public void setFields(AbstractField[] fields) {
        this.fields = fields;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public void setRoute(String route) {
        this.route = route;
    }

    public void setLists(Selection[] lists) {
        this.lists = lists;
    }

    public void setUniques(Selection[] uniques) {
        this.uniques = uniques;
    }

    public void setCounts(Selection[] counts) {
        this.counts = counts;
    }

    public void setFilters(Filter[] filters) {
        this.filters = filters;
    }

    public void setFiltersMap(Map<String, Filter[]> filtersMap) {
        this.filtersMap = filtersMap;
    }

    @Override
    public void setExtAttributes(Map<N2oNamespace, Map<String, String>> extAttributes) {
        this.extAttributes = extAttributes;
    }

    public static class Selection
    implements Source,
    Compiled {
        private String[] filters;
        private String resultMapping;
        private String resultNormalize;
        private String countMapping;
        private String ascExpression;
        private String descExpression;
        private String additionalMapping;
        private N2oInvocation invocation;
        private Type type;

        public Selection(Type type) {
            this.type = type;
        }

        public Selection(Type type, N2oInvocation invocation) {
            this(type);
            this.invocation = invocation;
        }

        public String[] getFilters() {
            return this.filters;
        }

        public String getResultMapping() {
            return this.resultMapping;
        }

        public String getResultNormalize() {
            return this.resultNormalize;
        }

        public String getCountMapping() {
            return this.countMapping;
        }

        public String getAscExpression() {
            return this.ascExpression;
        }

        public String getDescExpression() {
            return this.descExpression;
        }

        public String getAdditionalMapping() {
            return this.additionalMapping;
        }

        public N2oInvocation getInvocation() {
            return this.invocation;
        }

        public Type getType() {
            return this.type;
        }

        public void setFilters(String[] filters) {
            this.filters = filters;
        }

        public void setResultMapping(String resultMapping) {
            this.resultMapping = resultMapping;
        }

        public void setResultNormalize(String resultNormalize) {
            this.resultNormalize = resultNormalize;
        }

        public void setCountMapping(String countMapping) {
            this.countMapping = countMapping;
        }

        public void setAscExpression(String ascExpression) {
            this.ascExpression = ascExpression;
        }

        public void setDescExpression(String descExpression) {
            this.descExpression = descExpression;
        }

        public void setAdditionalMapping(String additionalMapping) {
            this.additionalMapping = additionalMapping;
        }

        public void setInvocation(N2oInvocation invocation) {
            this.invocation = invocation;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public static enum Type {
            list,
            unique,
            count;

        }
    }

    public static class Filter
    implements Source,
    Compiled {
        private String text;
        private String defaultValue;
        private Object compiledDefaultValue;
        private FilterType type;
        private String filterId;
        private String fieldId;
        private String domain;
        private String normalize;
        private String mapping;
        private Boolean required;
        private String param;
        private boolean generated = false;

        public Filter(String filterId, FilterType type) {
            this.filterId = filterId;
            this.type = type;
        }

        public Filter(String filterId, FilterType type, String filterBody) {
            this.text = filterBody;
            this.filterId = filterId;
            this.type = type;
        }

        public Filter(String filterId, FilterType type, String filterBody, String domain) {
            this.filterId = filterId;
            this.type = type;
            this.text = filterBody;
            this.domain = domain;
        }

        public Filter(String filterId, FilterType type, String filterBody, String domain, String normalize) {
            this.type = type;
            this.filterId = filterId;
            this.domain = domain;
            this.normalize = normalize;
            this.text = filterBody;
        }

        public Filter() {
        }

        public String getText() {
            return this.text;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public Object getCompiledDefaultValue() {
            return this.compiledDefaultValue;
        }

        public FilterType getType() {
            return this.type;
        }

        public String getFilterId() {
            return this.filterId;
        }

        public String getFieldId() {
            return this.fieldId;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getNormalize() {
            return this.normalize;
        }

        public String getMapping() {
            return this.mapping;
        }

        public Boolean getRequired() {
            return this.required;
        }

        public String getParam() {
            return this.param;
        }

        public boolean isGenerated() {
            return this.generated;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setCompiledDefaultValue(Object compiledDefaultValue) {
            this.compiledDefaultValue = compiledDefaultValue;
        }

        public void setType(FilterType type) {
            this.type = type;
        }

        public void setFilterId(String filterId) {
            this.filterId = filterId;
        }

        public void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public void setNormalize(String normalize) {
            this.normalize = normalize;
        }

        public void setMapping(String mapping) {
            this.mapping = mapping;
        }

        public void setRequired(Boolean required) {
            this.required = required;
        }

        public void setParam(String param) {
            this.param = param;
        }

        public void setGenerated(boolean generated) {
            this.generated = generated;
        }
    }
}

