/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.global.dao;

import java.util.Objects;
import net.n2oapp.criteria.filters.FilterType;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;

public class N2oPreFilter
implements Source {
    private String fieldId;
    private String valueAttr;
    private String valuesAttr;
    private FilterType type;
    private String param;
    private Boolean routable;
    private String refPageId;
    private String datasourceId;
    private ReduxModel model;
    private String[] valueList;
    private Boolean required;
    private Boolean resetOnChange;

    public N2oPreFilter() {
    }

    public N2oPreFilter(String fieldId, FilterType type) {
        this.fieldId = fieldId;
        this.type = type;
    }

    public N2oPreFilter(String fieldId, String value, FilterType type) {
        this.fieldId = fieldId;
        this.type = type;
        this.valueAttr = value;
    }

    public N2oPreFilter(String fieldId, String[] values, FilterType type) {
        this.fieldId = fieldId;
        this.type = type;
        this.valueList = values;
    }

    public String getRef() {
        return StringUtils.unwrapLink(this.getValue());
    }

    public void setRef(String ref) {
        this.valueAttr = Placeholders.ref(ref);
    }

    public boolean isRef() {
        return this.getRef() != null;
    }

    @Deprecated
    public String getRefWidgetId() {
        return this.datasourceId;
    }

    @Deprecated
    public void setRefWidgetId(String refWidgetId) {
        this.datasourceId = refWidgetId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof N2oPreFilter)) {
            return false;
        }
        N2oPreFilter that = (N2oPreFilter)o;
        return Objects.equals(this.fieldId, that.fieldId) && Objects.equals(this.datasourceId, that.datasourceId) && this.model == that.model && this.type == that.type;
    }

    public boolean isBoolean() {
        return FilterType.isNull.equals((Object)this.getType()) || FilterType.isNotNull.equals((Object)this.getType());
    }

    public boolean isArray() {
        return this.getValues() != null && this.getValues().length != 0;
    }

    public int hashCode() {
        return Objects.hash(this.fieldId, this.datasourceId, this.model, this.type);
    }

    public String[] getValues() {
        return this.valueList != null && this.valueList.length > 0 ? this.valueList : null;
    }

    public String getValue() {
        return this.valueAttr == null ? this.valuesAttr : this.valueAttr;
    }

    public String toString() {
        return "N2oPreFilter{fieldId='" + this.fieldId + "', type=" + String.valueOf(this.type) + "}";
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public String getValueAttr() {
        return this.valueAttr;
    }

    public String getValuesAttr() {
        return this.valuesAttr;
    }

    public FilterType getType() {
        return this.type;
    }

    public String getParam() {
        return this.param;
    }

    public Boolean getRoutable() {
        return this.routable;
    }

    public String getRefPageId() {
        return this.refPageId;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public ReduxModel getModel() {
        return this.model;
    }

    public String[] getValueList() {
        return this.valueList;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public Boolean getResetOnChange() {
        return this.resetOnChange;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public void setValueAttr(String valueAttr) {
        this.valueAttr = valueAttr;
    }

    public void setValuesAttr(String valuesAttr) {
        this.valuesAttr = valuesAttr;
    }

    public void setType(FilterType type) {
        this.type = type;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public void setRoutable(Boolean routable) {
        this.routable = routable;
    }

    public void setRefPageId(String refPageId) {
        this.refPageId = refPageId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public void setModel(ReduxModel model) {
        this.model = model;
    }

    public void setValueList(String[] valueList) {
        this.valueList = valueList;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public void setResetOnChange(Boolean resetOnChange) {
        this.resetOnChange = resetOnChange;
    }
}

