/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.domain;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import net.n2oapp.criteria.dataset.DataSet;

public enum Domain {
    STRING("string", String.class),
    INTEGER("integer", Integer.class),
    NUMERIC("numeric", BigDecimal.class),
    LONG("long", Long.class),
    BYTE("byte", Byte.class),
    SHORT("short", Short.class),
    BOOLEAN("boolean", Boolean.class),
    DATE("date", Date.class, "YYYY-MM-DDTHH:mm:ss"),
    LOCALDATE("localdate", LocalDate.class, "YYYY-MM-DD"),
    LOCALDATETIME("localdatetime", LocalDateTime.class, "YYYY-MM-DDTHH:mm:ss"),
    ZONEDDATETIME("zoneddatetime", ZonedDateTime.class, "YYYY-MM-DDTHH:mm:ssZ"),
    OFFSETDATETIME("offsetdatetime", OffsetDateTime.class, "YYYY-MM-DDTHH:mm:ssZ"),
    OBJECT("object", DataSet.class);

    private final String name;
    private final Class<?> type;
    private String jsFormat;

    private Domain(String name, Class<?> type) {
        this.name = name;
        this.type = type;
    }

    private Domain(String name, Class<?> type, String jsFormat) {
        this.name = name;
        this.type = type;
        this.jsFormat = jsFormat;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getJsFormat() {
        return this.jsFormat;
    }

    public String getArray() {
        return this.getName() + "[]";
    }

    public static Domain getByName(String name) {
        for (Domain domain : Domain.values()) {
            if (!domain.getName().equalsIgnoreCase(name)) continue;
            return domain;
        }
        return null;
    }

    public static Domain getByClass(Class<?> clazz) {
        for (Domain domain : Domain.values()) {
            if (!domain.getType().equals(clazz)) continue;
            return domain;
        }
        return null;
    }
}

