/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.compile;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Stream;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.metadata.aware.IdAware;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;

public interface SourceProcessor {
    public <T extends Source> void validate(T var1, Object ... var2);

    public <S extends Source> S merge(S var1, S var2);

    public <S extends SourceMetadata> S getSource(String var1, Class<S> var2);

    public <T extends SourceMetadata> T getOrThrow(String var1, Class<T> var2);

    public <D> D getScope(Class<D> var1);

    public <T> T resolve(String var1, Class<T> var2);

    public Object resolve(String var1, String var2);

    public Object resolve(String var1);

    public String getMessage(String var1, Object ... var2);

    default public void checkNotNull(Object something, String errorMessage) {
        if (something == null) {
            throw new N2oMetadataValidationException(this.getMessage(errorMessage, new Object[0]));
        }
    }

    public <T extends SourceMetadata> void checkForExists(String var1, Class<T> var2, String var3);

    public void checkId(IdAware var1, String var2);

    default public <T> Stream<T> safeStreamOf(T[] values) {
        return values == null ? Stream.empty() : Stream.of(values);
    }

    default public <T> Stream<T> safeStreamOf(Collection<T> values) {
        return values == null ? Stream.empty() : values.stream();
    }

    default public void checkIdExistence(IdAware metadata, String errorMessage) {
        this.checkNotNull(metadata.getId(), errorMessage);
    }

    default public <T extends IdAware> void checkIdsUnique(T[] list, String errorMessage) {
        if (list != null) {
            this.checkIdsUnique(Arrays.asList(list), errorMessage);
        }
    }

    default public <T extends IdAware> void checkIdsUnique(Collection<T> list, String errorMessage) {
        if (list == null) {
            return;
        }
        HashSet<String> uniqueSet = new HashSet<String>();
        for (IdAware item : list) {
            if (item.getId() == null || uniqueSet.add(item.getId())) continue;
            throw new N2oMetadataValidationException(String.format(errorMessage, item.getId()));
        }
    }
}

