/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.event;

import net.n2oapp.framework.api.event.N2oEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class N2oEventBus {
    private Logger logger = LoggerFactory.getLogger(N2oEventBus.class);
    private ApplicationEventPublisher publisher;

    public N2oEventBus(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public <E extends N2oEvent> void publish(E e) {
        long i = 0L;
        if (this.logger.isDebugEnabled()) {
            i = System.currentTimeMillis();
        }
        this.publisher.publishEvent(e);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("publishing event '{}' took {} ms", (Object)((Object)e).getClass().getSimpleName(), (Object)(System.currentTimeMillis() - i));
        }
    }
}

