/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.data.validation;

import java.util.LinkedHashMap;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.criteria.dataset.DataSetUtil;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.data.InvocationProcessor;
import net.n2oapp.framework.api.data.validation.InvocationValidation;
import net.n2oapp.framework.api.data.validation.ValidationFailureCallback;
import net.n2oapp.framework.api.metadata.global.dao.object.AbstractParameter;
import net.n2oapp.framework.api.metadata.global.view.page.N2oDialog;

public class DialogValidation
extends InvocationValidation {
    private N2oDialog dialog;

    @Override
    public void validate(DataSet dataSet, InvocationProcessor serviceProvider, ValidationFailureCallback callback, DomainProcessor domainProcessor) {
        DataSet result;
        dataSet = domainProcessor.doDomainConversation(dataSet, this.getInParametersList());
        if (this.getInvocation() != null) {
            result = serviceProvider.invoke(this.getInvocation(), dataSet, this.getInParametersList(), this.getOutParametersList());
        } else {
            LinkedHashMap<String, String> outMapping = new LinkedHashMap<String, String>();
            if (this.getOutParametersList() != null) {
                for (AbstractParameter parameter : this.getOutParametersList()) {
                    outMapping.put(parameter.getId(), parameter.getMapping());
                }
            }
            result = DataSetUtil.extract((Object)dataSet, outMapping);
        }
        if (result.get((Object)"validation") == null || !((Boolean)result.get((Object)"validation")).booleanValue()) {
            callback.onFail(StringUtils.resolveLinks(this.getMessage(), result));
        }
    }

    @Override
    public String getType() {
        return "dialog";
    }

    public N2oDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(N2oDialog dialog) {
        this.dialog = dialog;
    }
}

