/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.data.validation;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.data.InvocationProcessor;
import net.n2oapp.framework.api.data.validation.InvocationValidation;
import net.n2oapp.framework.api.data.validation.ValidationFailureCallback;
import net.n2oapp.framework.api.metadata.global.dao.object.AbstractParameter;

public class ConstraintValidation
extends InvocationValidation {
    private Set<String> requiredFields;

    public ConstraintValidation() {
    }

    public ConstraintValidation(ConstraintValidation validation) {
        super(validation);
        this.requiredFields = validation.getRequiredFields();
    }

    @Override
    public void setInParametersList(List<AbstractParameter> inParametersList) {
        super.setInParametersList(inParametersList);
        this.requiredFields = inParametersList.stream().filter(p -> Boolean.TRUE.equals(p.getRequired())).map(AbstractParameter::getId).collect(Collectors.toSet());
    }

    @Override
    public void validate(DataSet dataSet, InvocationProcessor serviceProvider, ValidationFailureCallback callback, DomainProcessor domainProcessor) {
        dataSet = domainProcessor.doDomainConversation(dataSet, this.getInParametersList());
        DataSet result = serviceProvider.invoke(this.getInvocation(), dataSet, this.getInParametersList(), this.getOutParametersList());
        if (result.get((Object)"validation") == null || !((Boolean)result.get((Object)"validation")).booleanValue()) {
            callback.onFail(StringUtils.resolveLinks(this.getMessage(), result));
        }
    }

    @Override
    public String getType() {
        return "constraint";
    }

    @Override
    public Set<String> getRequiredFields() {
        return this.requiredFields;
    }

    public void setRequiredFields(Set<String> requiredFields) {
        this.requiredFields = requiredFields;
    }
}

