/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.data.validation;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.script.ScriptException;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.data.InvocationProcessor;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.data.validation.ValidationFailureCallback;
import net.n2oapp.framework.api.script.ScriptProcessor;
import org.apache.commons.lang3.ArrayUtils;

public class ConditionValidation
extends Validation {
    @JsonProperty
    private String expression;
    @JsonProperty(value="on")
    private String[] expressionOn;

    public ConditionValidation(ConditionValidation validation) {
        super(validation);
        this.expression = validation.getExpression();
        this.expressionOn = validation.getExpressionOn();
    }

    public void setExpression(String expression) {
        if (expression != null) {
            this.expression = expression.replaceAll("\n|\r", "").trim();
        }
    }

    private Set<String> getExpressionsOn() {
        if (ArrayUtils.isEmpty((Object[])this.expressionOn)) {
            return Collections.emptySet();
        }
        return Arrays.stream(this.expressionOn).collect(Collectors.toSet());
    }

    private DataSet getCopiedDataSet(DataSet dataSet, DomainProcessor domainProcessor) {
        DataSet copiedDataSet = new DataSet((Map)dataSet);
        this.getExpressionsOn().forEach(key -> {
            Object value = dataSet.get(key);
            copiedDataSet.put(key, value instanceof Date ? domainProcessor.serialize(value) : value);
        });
        return copiedDataSet;
    }

    @Override
    public void validate(DataSet dataSet, InvocationProcessor serviceProvider, ValidationFailureCallback callback, DomainProcessor domainProcessor) {
        try {
            DataSet copiedDataSet = this.getCopiedDataSet(dataSet, domainProcessor);
            if (!((Boolean)ScriptProcessor.eval(this.getExpression(), copiedDataSet)).booleanValue()) {
                callback.onFail(StringUtils.resolveLinks(this.getMessage(), copiedDataSet));
            }
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getType() {
        return "condition";
    }

    public String getExpression() {
        return this.expression;
    }

    public String[] getExpressionOn() {
        return this.expressionOn;
    }

    @JsonProperty(value="on")
    public void setExpressionOn(String[] expressionOn) {
        this.expressionOn = expressionOn;
    }

    public ConditionValidation() {
    }
}

