/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.data;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.criteria.dataset.Interval;
import net.n2oapp.criteria.filters.FilterType;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.aware.IdAware;
import net.n2oapp.framework.api.metadata.domain.Domain;
import net.n2oapp.framework.api.metadata.global.dao.object.AbstractParameter;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectSimpleField;
import net.n2oapp.framework.api.metadata.local.CompiledObject;

public class DomainProcessor {
    public static final String JAVA_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private final ObjectMapper objectMapper;

    public DomainProcessor(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(JAVA_DATE_FORMAT));
    }

    public DomainProcessor() {
        this(new ObjectMapper());
    }

    public Object deserialize(Object value, String domain) {
        if (value == null) {
            return null;
        }
        if (StringUtils.isDynamicValue(value)) {
            return value;
        }
        if (value instanceof String) {
            String strValue = (String)value;
            if (strValue.isEmpty()) {
                return null;
            }
            if (StringUtils.isEscapedString(strValue)) {
                value = StringUtils.unwrapEscapedString(strValue);
                domain = Domain.STRING.getName();
            }
        }
        if (domain == null && (domain = this.findDomain(value)) == null) {
            return value;
        }
        if (this.isArray(domain = domain.toLowerCase())) {
            return this.convertArray(value, domain);
        }
        if (this.isInterval(domain)) {
            return this.convertInterval(value, domain);
        }
        if (StringUtils.isJson(value)) {
            return this.convertObject(((String)value).substring(1, ((String)value).length() - 1), domain);
        }
        return this.convertObject(value, domain);
    }

    public Object deserialize(Object value, Domain domain) {
        return this.deserialize(value, domain != null ? domain.getName() : null);
    }

    public Object deserialize(Object value, Class<?> clazz) {
        if (clazz.isEnum()) {
            return this.deserializeEnum(value, clazz);
        }
        Object result = this.deserialize(value, Domain.getByClass(clazz));
        if (result != null && !StringUtils.isDynamicValue(result) && !clazz.isAssignableFrom(result.getClass())) {
            throw new ClassCastException(String.format("Value [%s] is not a %s", value, clazz));
        }
        return result;
    }

    public Object deserialize(Object value) {
        return this.deserialize(value, (String)null);
    }

    public <T extends Enum<T>> T deserializeEnum(Object value, Class<T> enumClass) {
        block6: {
            if (value == null) {
                return null;
            }
            if (enumClass.isAssignableFrom(value.getClass())) {
                return (T)((Enum)value);
            }
            if (!(value instanceof String)) break block6;
            String strValue = (String)value;
            boolean idAware = IdAware.class.isAssignableFrom(enumClass);
            if (idAware) {
                for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                    IdAware idEnum = (IdAware)((Object)enumValue);
                    if (!idEnum.getId().equalsIgnoreCase(strValue)) continue;
                    return (T)enumValue;
                }
            } else {
                for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                    if (!enumValue.name().equalsIgnoreCase(strValue)) continue;
                    return (T)enumValue;
                }
            }
        }
        return null;
    }

    public String serialize(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String || value instanceof Boolean) {
            return value.toString();
        }
        try {
            return this.objectMapper.writeValueAsString(value).replace("\"", "");
        }
        catch (JsonProcessingException e) {
            throw new N2oException(e);
        }
    }

    public DataSet domainConversionByAction(DataSet inDataSet, CompiledObject.Operation operation) {
        return this.doDomainConversation(inDataSet, operation.getInParametersMap().values());
    }

    public DataSet doDomainConversation(DataSet inDataSet, Collection<AbstractParameter> values) {
        for (AbstractParameter param : values) {
            String paramName;
            Object value;
            if (!(param instanceof ObjectSimpleField) || (value = inDataSet.get((Object)(paramName = param.getId()))) == null) continue;
            String domain = ((ObjectSimpleField)param).getDomain();
            inDataSet.put(paramName, this.deserialize(value, domain));
        }
        return inDataSet;
    }

    private Object convertObject(Object value, String domain) {
        if (value instanceof String || value instanceof Number) {
            try {
                return this.toObject(domain, value.toString());
            }
            catch (IOException | ParseException e) {
                throw new IllegalStateException(String.format("failed to cast to type [%s] value [%s]", domain, value), e);
            }
        }
        return value;
    }

    private Interval<?> convertInterval(Object value, String domain) {
        Object end;
        Object begin;
        Interval res = new Interval();
        String domainElement = domain.replaceAll("interval\\{", "").replaceAll("\\}", "");
        if (value instanceof String && ((String)value).startsWith("{") && ((String)value).endsWith("}")) {
            try {
                value = this.objectMapper.readValue((String)value, Map.class);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        if (value instanceof Collection) {
            Iterator iterator = ((Collection)value).iterator();
            begin = iterator.hasNext() ? iterator.next() : null;
            end = iterator.hasNext() ? iterator.next() : null;
        } else if (value instanceof Map) {
            Map map = (Map)value;
            begin = map.getOrDefault("begin", map.get("from"));
            end = map.getOrDefault("end", map.get("to"));
        } else {
            throw new IllegalStateException("Value " + String.valueOf(value) + " is not an interval");
        }
        res.setBegin(this.deserialize(begin, domainElement));
        res.setEnd(this.deserialize(end, domainElement));
        return res;
    }

    private Object convertArray(Object value, String domain) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        String domainElement = domain.replaceAll("\\[\\]", "");
        if (value instanceof String && ((String)value).startsWith("[") && ((String)value).endsWith("]")) {
            try {
                value = this.objectMapper.readValue((String)value, List.class);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        if (value instanceof String) {
            String[] elements;
            String string = (String)value;
            for (String element : elements = string.split(",")) {
                resultList.add(this.deserialize((Object)element, domainElement));
            }
        } else if (value instanceof Collection) {
            for (Object element : (Collection)value) {
                resultList.add(this.deserialize(element, domainElement));
            }
        } else {
            throw new IllegalStateException("Value " + String.valueOf(value) + " is not a collection");
        }
        return resultList;
    }

    private boolean isInterval(String domain) {
        return domain.contains("interval");
    }

    private boolean isArray(String domain) {
        return domain.contains("[]");
    }

    private String findDomain(Object value) {
        if (value instanceof Collection) {
            if (((Collection)value).isEmpty()) {
                return "integer[]";
            }
            Optional<Object> firstElement = ((Collection)value).stream().filter(Objects::nonNull).findFirst();
            if (firstElement.isEmpty()) {
                return null;
            }
            String elementsDomain = this.findDomain(firstElement.get());
            if (elementsDomain == null) {
                return null;
            }
            return elementsDomain + "[]";
        }
        if (value instanceof String) {
            String val = ((String)value).toLowerCase();
            if (val.equals("true") || value.equals("false")) {
                return Domain.BOOLEAN.getName();
            }
            if (val.length() <= 6 && val.chars().allMatch(Character::isDigit)) {
                try {
                    Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    throw new N2oException("Value is not Integer [" + val + "]. Set domain explicitly!", e);
                }
                return Domain.INTEGER.getName();
            }
            return Domain.STRING.getName();
        }
        Domain domain = Domain.getByClass(value.getClass());
        return domain != null ? domain.getName() : null;
    }

    private Object toObject(String domain, String value) throws ParseException, IOException {
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (Domain.STRING.getName().equals(domain)) {
            return value;
        }
        if (Domain.BOOLEAN.getName().equals(domain)) {
            return Boolean.parseBoolean(value);
        }
        if (Domain.DATE.getName().equals(domain)) {
            return this.objectMapper.getDateFormat().parse(value);
        }
        if (Domain.ZONEDDATETIME.getName().equals(domain)) {
            return ZonedDateTime.parse(value, DateTimeFormatter.ISO_ZONED_DATE_TIME);
        }
        if (Domain.OFFSETDATETIME.getName().equals(domain)) {
            return OffsetDateTime.parse(value, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        if (Domain.LOCALDATETIME.getName().equals(domain)) {
            return LocalDateTime.parse(value, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        if (Domain.LOCALDATE.getName().equals(domain)) {
            return LocalDate.parse(value, new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter());
        }
        if (Domain.BYTE.getName().equals(domain)) {
            return Byte.parseByte(value);
        }
        if (Domain.SHORT.getName().equals(domain)) {
            return Short.parseShort(value);
        }
        if (Domain.INTEGER.getName().equals(domain)) {
            return Integer.parseInt(value);
        }
        if (Domain.LONG.getName().equals(domain)) {
            return Long.parseLong(value);
        }
        if (Domain.NUMERIC.getName().equals(domain)) {
            return new BigDecimal(value.replace(",", "."));
        }
        if (Domain.OBJECT.getName().equals(domain)) {
            return this.objectMapper.readValue(value, DataSet.class);
        }
        return value;
    }

    public static String getDomain(String simpleDomain, FilterType type) {
        switch (type.arity) {
            case unary: {
                return simpleDomain;
            }
            case n_ary: {
                return simpleDomain != null ? simpleDomain + "[]" : null;
            }
            case nullary: {
                return "boolean";
            }
        }
        throw new IllegalStateException(String.format("arity '%s' for filter-type '%s' is unknown", type.arity, type));
    }
}

