/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.context;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.n2oapp.framework.api.NotFoundPlaceholderException;
import net.n2oapp.framework.api.PlaceHoldersResolver;
import net.n2oapp.framework.api.context.Context;
import net.n2oapp.framework.api.exception.NotFoundContextPlaceholderException;

public class ContextProcessor {
    private final PlaceHoldersResolver contextResolver = new PlaceHoldersResolver("#{", "}");
    private Context context;

    public ContextProcessor(Context context) {
        this.context = context;
    }

    public boolean hasContext(String text) {
        return this.contextResolver.hasPlaceHolders(text);
    }

    public String resolveText(String text) {
        try {
            return this.contextResolver.resolve(text, PlaceHoldersResolver.replaceNullByEmpty(PlaceHoldersResolver.replaceOptional(this.context::get)));
        }
        catch (NotFoundPlaceholderException e) {
            throw new NotFoundContextPlaceholderException(e.getPlaceholder());
        }
    }

    public String resolveJson(String json, ObjectMapper objectMapper) {
        try {
            return this.contextResolver.resolveJson(json, PlaceHoldersResolver.replaceOptional(this.context::get), objectMapper);
        }
        catch (NotFoundPlaceholderException e) {
            throw new NotFoundContextPlaceholderException(e.getPlaceholder());
        }
    }

    public Object resolve(Object param) {
        if (param instanceof List) {
            return this.resolveValues((List)param);
        }
        return this.resolveValue(param);
    }

    public void set(Map<String, Object> dataSet) {
        this.context.set(dataSet);
    }

    public void set(String name, Object value) {
        this.context.set(name, value);
    }

    public Object get(String name) {
        return this.context.get(name);
    }

    private Object resolveValue(Object param) {
        try {
            return this.contextResolver.resolveValue(param, PlaceHoldersResolver.replaceOptional(this.context::get));
        }
        catch (NotFoundPlaceholderException e) {
            throw new NotFoundContextPlaceholderException(e.getPlaceholder());
        }
    }

    private List<?> resolveValues(List<?> params) {
        ArrayList<Object> result = new ArrayList<Object>();
        boolean changed = false;
        for (Object param : params) {
            Object value;
            if (param != (value = this.resolveValue(param))) {
                changed = true;
            }
            result.add(value);
        }
        return changed ? result : params;
    }
}

