/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import net.n2oapp.framework.api.config.AppConfig;
import org.apache.commons.io.IOUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public interface ConfigBuilder<T extends AppConfig> {
    default public ConfigBuilder<T> user(Object user) {
        return this.add("user", user);
    }

    default public ConfigBuilder<T> menu(Object menu) {
        return this.add("menu", menu);
    }

    default public ConfigBuilder<T> messages(ResourceBundle resourceBundle, MessageSourceAccessor messageSource) {
        return this.messages(resourceBundle, messageSource, LocaleContextHolder.getLocale());
    }

    default public ConfigBuilder<T> messages(ResourceBundle resourceBundle, MessageSourceAccessor messageSource, Locale locale) {
        LinkedHashMap<String, String> messages = new LinkedHashMap<String, String>();
        for (String key : resourceBundle.keySet()) {
            messages.put(key, messageSource.getMessage(key, locale));
        }
        return this.add("messages", messages);
    }

    public ConfigBuilder<T> add(String var1, Object var2);

    public ConfigBuilder<T> addAll(Map<String, Object> var1);

    default public ConfigBuilder<T> read(File file) {
        return this.read((Resource)new FileSystemResource(file));
    }

    default public ConfigBuilder<T> read(Resource resource) {
        try {
            return this.read(resource.getInputStream());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    default public ConfigBuilder<T> read(InputStream content) {
        try {
            return this.read(IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public ConfigBuilder<T> read(String var1);

    public void write(Writer var1);

    public void write(File var1);

    public T get();
}

