/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.n2oapp.criteria.dataset.NestedUtils;
import net.n2oapp.framework.api.NotFoundPlaceholderException;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.exception.N2oException;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.core.env.PropertyResolver;

public class PlaceHoldersResolver {
    private static final String OPTIONAL_SUFFIX = "?";
    private static final String REQUIRED_SUFFIX = "!";
    private String prefix;
    private String suffix;
    private Boolean onlyJavaVariable;
    private Function<String, Integer> defaultSuffixIdx = str -> {
        String[] ends = str.split("\\W");
        return ends.length > 0 ? ends[0].length() : 0;
    };

    public PlaceHoldersResolver(String prefix, String suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.onlyJavaVariable = false;
    }

    public PlaceHoldersResolver(String prefix, String suffix, Boolean onlyJavaVariable, Function<String, Integer> defaultSuffixIdx) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.defaultSuffixIdx = defaultSuffixIdx;
        this.onlyJavaVariable = onlyJavaVariable;
    }

    public PlaceHoldersResolver(String prefix, String suffix, Boolean onlyJavaVariable) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.onlyJavaVariable = onlyJavaVariable;
    }

    public String resolve(String text, Object data) {
        if (data == null) {
            return text;
        }
        return this.safeResolve(text, this.notReplaceNull(PlaceHoldersResolver.function(data)));
    }

    public String resolve(String text, Function<String, Object> func) {
        return this.safeResolve(text, this.notReplaceNull(func));
    }

    public String resolveJson(String json, Function<String, Object> func, ObjectMapper objectMapper) {
        try {
            return objectMapper.writeValueAsString((Object)this.resolvePlaceholders(objectMapper.readTree(json), func::apply));
        }
        catch (IOException e) {
            throw new N2oException(e);
        }
    }

    public Object resolveValue(Object placeholder, Function<String, Object> func) {
        return this.safeResolveValue(placeholder, func);
    }

    public Object resolveValue(Object placeholder, Map<String, Object> data) {
        return this.safeResolveValue(placeholder, data::get);
    }

    public Set<String> extractPlaceHolders(String text) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (text == null) {
            return result;
        }
        String[] split = text.split(Pattern.quote(this.prefix));
        if (split.length > 1) {
            for (int i = 1; i < split.length; ++i) {
                int idxSuffix = split[i].indexOf(this.suffix);
                if (idxSuffix <= 0) continue;
                result.add(split[i].substring(0, idxSuffix));
            }
        }
        return result;
    }

    public boolean hasPlaceHolders(String text) {
        return text != null && text.contains(this.prefix) && text.contains(this.suffix) && text.indexOf(this.prefix) < text.indexOf(this.suffix);
    }

    public boolean isPlaceHolder(Object param) {
        if (param == null) {
            return false;
        }
        if (!(param instanceof String)) {
            return false;
        }
        String text = (String)param;
        return text.startsWith(this.prefix) && text.endsWith(this.suffix);
    }

    private static Function<String, Object> function(Object data) {
        if (data instanceof Function) {
            return (Function)data;
        }
        if (data instanceof PropertyResolver) {
            return arg_0 -> ((PropertyResolver)((PropertyResolver)data)).getProperty(arg_0);
        }
        if (data instanceof Map) {
            return ((Map)data)::get;
        }
        if (data instanceof List) {
            return k -> ((List)data).get(Integer.parseInt(k));
        }
        if (data != null && data.getClass().isArray()) {
            Object[] array = (Object[])data;
            return k -> array[Integer.parseInt(k)];
        }
        if (data instanceof String || data instanceof Number || data instanceof Date) {
            return k -> data;
        }
        try {
            Map map = BeanUtils.describe((Object)data);
            return map::get;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String safeResolve(String text, Function<String, Object> callback) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String[] split = text.split(Pattern.quote(this.prefix));
        if (split.length <= 1) {
            return text;
        }
        sb.append(split[0]);
        for (int i = 1; i < split.length; ++i) {
            int idxNext;
            int idxSuffix;
            if (this.suffix != null && !this.suffix.isEmpty()) {
                idxSuffix = split[i].indexOf(this.suffix);
                idxNext = idxSuffix + 1;
                if (idxSuffix == 0) {
                    sb.append(this.prefix).append(this.suffix);
                    sb.append(split[i].substring(idxNext));
                }
            } else {
                idxNext = idxSuffix = this.defaultSuffixIdx.apply(split[i]).intValue();
                if (idxSuffix == 0) {
                    sb.append(this.prefix);
                    sb.append(split[i].substring(idxNext));
                }
            }
            if (idxSuffix <= 0) continue;
            String placeholder = split[i].substring(0, idxSuffix);
            if (this.onlyJavaVariable.booleanValue() && !NestedUtils.isJavaVariable((String)placeholder)) {
                sb.append(this.prefix);
                sb.append(split[i]);
                continue;
            }
            Object value = callback.apply(placeholder);
            sb.append(value);
            sb.append(split[i].substring(idxNext));
        }
        return sb.toString();
    }

    private JsonNode resolvePlaceholders(JsonNode json, Function<String, Object> callback) {
        if (json == null) {
            return null;
        }
        if (json.isObject()) {
            ObjectNode root = (ObjectNode)json;
            Iterator fields = root.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                if (((JsonNode)field.getValue()).isTextual()) {
                    Object result;
                    String value = ((JsonNode)field.getValue()).textValue();
                    if (this.isPlaceHolder(value)) {
                        result = this.safeResolveValue(value, callback);
                        field.setValue(new POJONode(result));
                        continue;
                    }
                    if (!this.hasPlaceHolders(value)) continue;
                    result = this.safeResolve(value, callback);
                    field.setValue(new TextNode((String)result));
                    continue;
                }
                if (((JsonNode)field.getValue()).isObject()) {
                    this.resolvePlaceholders((JsonNode)field.getValue(), callback);
                    continue;
                }
                if (!((JsonNode)field.getValue()).isArray()) continue;
                ArrayNode array = (ArrayNode)field.getValue();
                for (JsonNode jsonNode : array) {
                    this.resolvePlaceholders(jsonNode, callback);
                }
            }
            return root;
        }
        if (json.isArray()) {
            ArrayNode array = (ArrayNode)json;
            for (JsonNode jsonNode : array) {
                this.resolvePlaceholders(jsonNode, callback);
            }
            return array;
        }
        return null;
    }

    private Object safeResolveValue(Object placeholder, Function<String, Object> func) {
        if (!this.isPlaceHolder(placeholder)) {
            return placeholder;
        }
        String text = (String)placeholder;
        return func.apply(text.substring(this.prefix.length(), text.length() - this.suffix.length()));
    }

    private Function<String, Object> notReplaceNull(Object data) {
        return key -> {
            Object result = PlaceHoldersResolver.function(data).apply((String)key);
            if (result instanceof Object[]) {
                result = ((Object[])result)[0];
            }
            return result != null ? result : this.prefix.concat((String)key).concat(this.suffix);
        };
    }

    private Function<String, Object> replaceNull(Object data) {
        return key -> PlaceHoldersResolver.function(data).apply((String)key);
    }

    public static Function<String, Object> replaceByJson(Function<String, Object> callback, ObjectMapper mapper) {
        return key -> {
            Object result = callback.apply((String)key);
            try {
                if (result instanceof String) {
                    return result;
                }
                return mapper.writeValueAsString(result);
            }
            catch (JsonProcessingException e) {
                throw new N2oException(e);
            }
        };
    }

    public static Function<String, Object> replaceNullByEmpty(Function<String, Object> callback) {
        return key -> {
            Object result = callback.apply((String)key);
            return result != null ? result.toString() : "";
        };
    }

    public static Function<String, Object> replaceNullByEmpty(Object data) {
        return PlaceHoldersResolver.replaceNullByEmpty(PlaceHoldersResolver.function(data));
    }

    public static Function<String, Object> replaceRequired(Function<String, Object> callback) {
        return key -> {
            Object value = callback.apply((String)key);
            if (StringUtils.isEmpty(value)) {
                throw new NotFoundPlaceholderException((String)key);
            }
            return value;
        };
    }

    public static Function<String, Object> replaceRequired(Object data) {
        return PlaceHoldersResolver.replaceRequired(PlaceHoldersResolver.function(data));
    }

    public static Function<String, Object> replaceOptional(Function<String, Object> data) {
        return key -> {
            String placeholder = PlaceHoldersResolver.extractPlaceholder(key);
            Object value = data.apply(placeholder);
            if (StringUtils.isEmpty(value)) {
                if (PlaceHoldersResolver.extractRequired(key)) {
                    throw new NotFoundPlaceholderException(placeholder);
                }
                return PlaceHoldersResolver.extractOptional(key);
            }
            return value;
        };
    }

    public static Function<String, Object> replaceOptional(Object data) {
        return PlaceHoldersResolver.replaceOptional(PlaceHoldersResolver.function(data));
    }

    private static String extractPlaceholder(String expression) {
        int idxOptional = expression.indexOf(OPTIONAL_SUFFIX);
        if (idxOptional < 0 && (idxOptional = expression.indexOf(REQUIRED_SUFFIX)) < 0) {
            return expression;
        }
        return expression.substring(0, idxOptional);
    }

    private static boolean extractRequired(String expression) {
        return !expression.contains(OPTIONAL_SUFFIX) && expression.endsWith(REQUIRED_SUFFIX);
    }

    private static Object extractOptional(String expression) {
        int optionalIdx = expression.indexOf(OPTIONAL_SUFFIX);
        if (optionalIdx == -1) {
            return null;
        }
        String defVal = expression.substring(optionalIdx + 1);
        return defVal.isEmpty() ? null : defVal;
    }
}

