/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.n2oapp.framework.api.util.RefUtil;

public abstract class DynamicUtil {
    public static boolean hasRefs(String id) {
        return RefUtil.hasRefs(id);
    }

    public static boolean isDynamic(String id) {
        return id.contains("?");
    }

    public static void checkDynamicIds(List<String> ids, String code) {
        if (ids != null) {
            ids.forEach(id -> {
                if (!DynamicUtil.isDynamic(id)) {
                    throw new RuntimeException(String.format("dynamic-metadata-provider [%s] provides not dynamic id [%s]", code, id));
                }
                if (!id.startsWith(code)) {
                    throw new RuntimeException(String.format("dynamic-metadata-provider [%s]  provides wrong id [%s]", code, id));
                }
            });
        }
    }

    public static String resolveTokens(String metadataId, String ... tokens) {
        String id = metadataId;
        if (DynamicUtil.hasRefs(metadataId) && tokens != null) {
            Set<String> refs = RefUtil.getRefs(metadataId);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            int i = 0;
            for (String ref : refs) {
                if (i >= tokens.length) {
                    throw new IllegalStateException("References more than tokens: metadataId = [" + metadataId + "], tokens = " + String.valueOf(Arrays.asList(tokens)));
                }
                placeholders.put(ref, tokens[i]);
                ++i;
            }
            id = RefUtil.resolve(metadataId, placeholders);
        }
        return id;
    }

    public static String reduceTokens(String metadataId, String ... tokens) {
        if (tokens != null && tokens.length > 0) {
            return metadataId + "$" + Stream.of(tokens).reduce((a, b) -> a + "," + b).get();
        }
        return metadataId;
    }
}

