/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.access.integration.metadata.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.n2oapp.framework.access.metadata.Security;
import net.n2oapp.framework.access.metadata.SecurityFilters;
import net.n2oapp.framework.access.metadata.accesspoint.AccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oObjectAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oObjectFilter;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oObjectFiltersAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oPageAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oUrlAccessPoint;
import net.n2oapp.framework.access.metadata.schema.permission.N2oPermission;
import net.n2oapp.framework.access.metadata.schema.role.N2oRole;
import net.n2oapp.framework.access.metadata.schema.simple.SimpleCompiledAccessSchema;
import net.n2oapp.framework.access.metadata.schema.user.N2oUserAccess;
import net.n2oapp.framework.access.simple.PermissionAndRoleCollector;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.aware.CompiledClassAware;
import net.n2oapp.framework.api.metadata.aware.PropertiesAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.CompileTransformer;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;

public abstract class BaseAccessTransformer<D extends Compiled, C extends CompileContext<?, ?>>
implements CompileTransformer<D, C>,
CompiledClassAware {
    private static String DEFAULT_OBJECT_ACCESS_DENIED = "n2o.access.deny_objects";
    private static String DEFAULT_PAGE_ACCESS_DENIED = "n2o.access.deny_pages";
    private static String DEFAULT_URL_ACCESS_DENIED = "n2o.access.deny_urls";

    protected void collectObjectAccess(PropertiesAware compiled, String objectId, String operationId, SimpleCompiledAccessSchema schema, CompileProcessor p) {
        List<N2oRole> roles;
        List<N2oPermission> permissions;
        List<N2oUserAccess> userAccesses;
        if (objectId == null) {
            return;
        }
        Security security = this.getSecurity(compiled);
        Security.SecurityObject securityObject = new Security.SecurityObject();
        if (security.getSecurityMap() == null) {
            security.setSecurityMap(new HashMap<String, Security.SecurityObject>());
        } else if (security.getSecurityMap().get("object") != null || security.getSecurityMap().get("custom") != null) {
            return;
        }
        if (schema.getPermitAllPoints() != null) {
            schema.getPermitAllPoints().stream().filter(ap -> ap instanceof N2oObjectAccessPoint && StringUtils.maskMatch((String)((N2oObjectAccessPoint)ap).getObjectId(), (String)objectId) && (operationId == null || StringUtils.maskMatch((String)((N2oObjectAccessPoint)ap).getAction(), (String)operationId))).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
                if (list.size() > 0) {
                    securityObject.setPermitAll(true);
                }
                return list;
            }));
        }
        if (schema.getAuthenticatedPoints() != null) {
            schema.getAuthenticatedPoints().stream().filter(ap -> ap instanceof N2oObjectAccessPoint && StringUtils.maskMatch((String)((N2oObjectAccessPoint)ap).getObjectId(), (String)objectId) && (operationId == null || StringUtils.maskMatch((String)((N2oObjectAccessPoint)ap).getAction(), (String)operationId))).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
                if (list.size() > 0) {
                    securityObject.setAuthenticated(true);
                }
                return list;
            }));
        }
        if (schema.getAnonymousPoints() != null) {
            schema.getAnonymousPoints().stream().filter(ap -> ap instanceof N2oObjectAccessPoint && StringUtils.maskMatch((String)((N2oObjectAccessPoint)ap).getObjectId(), (String)objectId) && (operationId == null || StringUtils.maskMatch((String)((N2oObjectAccessPoint)ap).getAction(), (String)operationId))).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
                if (list.size() > 0) {
                    securityObject.setAnonymous(true);
                }
                return list;
            }));
        }
        if ((userAccesses = PermissionAndRoleCollector.collectUsers(N2oObjectAccessPoint.class, PermissionAndRoleCollector.OBJECT_ACCESS.apply(objectId, operationId), schema)) != null && userAccesses.size() > 0) {
            securityObject.setUsernames(userAccesses.stream().map(N2oUserAccess::getId).collect(Collectors.toSet()));
        }
        if ((permissions = PermissionAndRoleCollector.collectPermission(N2oObjectAccessPoint.class, PermissionAndRoleCollector.OBJECT_ACCESS.apply(objectId, operationId), schema)) != null && permissions.size() > 0) {
            securityObject.setPermissions(permissions.stream().map(N2oPermission::getId).collect(Collectors.toSet()));
        }
        if ((roles = PermissionAndRoleCollector.collectRoles(N2oObjectAccessPoint.class, PermissionAndRoleCollector.OBJECT_ACCESS.apply(objectId, operationId), schema)) != null && roles.size() > 0) {
            securityObject.setRoles(roles.stream().map(N2oRole::getId).collect(Collectors.toSet()));
        }
        if (securityObject.isEmpty()) {
            Boolean defaultObjectAccessDenied = (Boolean)p.resolve(Placeholders.property((String)DEFAULT_OBJECT_ACCESS_DENIED), Boolean.class);
            securityObject.setPermitAll(defaultObjectAccessDenied == false);
            securityObject.setDenied(defaultObjectAccessDenied);
        }
        security.getSecurityMap().put("object", securityObject);
    }

    protected void collectPageAccess(PropertiesAware compiled, String pageId, SimpleCompiledAccessSchema schema, CompileProcessor p) {
        List<N2oUserAccess> userAccesses;
        List<N2oPermission> permissions;
        List<N2oRole> roles;
        if (pageId == null) {
            return;
        }
        Security security = this.getSecurity(compiled);
        if (security.getSecurityMap() == null) {
            security.setSecurityMap(new HashMap<String, Security.SecurityObject>());
        } else if (security.getSecurityMap().get("page") != null || security.getSecurityMap().get("custom") != null) {
            return;
        }
        Security.SecurityObject securityObject = new Security.SecurityObject();
        if (schema.getPermitAllPoints() != null) {
            schema.getPermitAllPoints().stream().filter(ap -> ap instanceof N2oPageAccessPoint && ((N2oPageAccessPoint)ap).getPage().equals(pageId)).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
                if (list.size() == 1) {
                    securityObject.setPermitAll(true);
                }
                return list;
            }));
        }
        if (schema.getAuthenticatedPoints() != null) {
            schema.getAuthenticatedPoints().stream().filter(ap -> ap instanceof N2oPageAccessPoint && ((N2oPageAccessPoint)ap).getPage().equals(pageId)).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
                if (list.size() == 1) {
                    securityObject.setAuthenticated(true);
                }
                return list;
            }));
        }
        if (schema.getAnonymousPoints() != null) {
            schema.getAnonymousPoints().stream().filter(ap -> ap instanceof N2oPageAccessPoint && ((N2oPageAccessPoint)ap).getPage().equals(pageId)).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
                if (list.size() == 1) {
                    securityObject.setAnonymous(true);
                }
                return list;
            }));
        }
        if ((roles = PermissionAndRoleCollector.collectRoles(N2oPageAccessPoint.class, PermissionAndRoleCollector.PAGE_ACCESS.apply(pageId), schema)) != null && roles.size() > 0) {
            securityObject.setRoles(roles.stream().map(N2oRole::getId).collect(Collectors.toSet()));
        }
        if ((permissions = PermissionAndRoleCollector.collectPermission(N2oPageAccessPoint.class, PermissionAndRoleCollector.PAGE_ACCESS.apply(pageId), schema)) != null && permissions.size() > 0) {
            securityObject.setPermissions(permissions.stream().map(N2oPermission::getId).collect(Collectors.toSet()));
        }
        if ((userAccesses = PermissionAndRoleCollector.collectUsers(N2oPageAccessPoint.class, PermissionAndRoleCollector.PAGE_ACCESS.apply(pageId), schema)) != null && userAccesses.size() > 0) {
            securityObject.setUsernames(userAccesses.stream().map(N2oUserAccess::getId).collect(Collectors.toSet()));
        }
        if (securityObject.isEmpty()) {
            Boolean defaultPageAccessDenied = (Boolean)p.resolve(Placeholders.property((String)DEFAULT_PAGE_ACCESS_DENIED), Boolean.class);
            securityObject.setPermitAll(defaultPageAccessDenied == false);
            securityObject.setDenied(defaultPageAccessDenied);
        }
        security.getSecurityMap().put("page", securityObject);
    }

    protected void collectUrlAccess(PropertiesAware compiled, String url, SimpleCompiledAccessSchema schema, CompileProcessor p) {
        List<N2oUserAccess> userAccesses;
        List<N2oPermission> permissions;
        List<N2oRole> roles;
        if (url == null) {
            return;
        }
        Security security = this.getSecurity(compiled);
        if (security.getSecurityMap() == null) {
            security.setSecurityMap(new HashMap<String, Security.SecurityObject>());
        } else if (security.getSecurityMap().get("url") != null || security.getSecurityMap().get("custom") != null) {
            return;
        }
        Security.SecurityObject securityObject = new Security.SecurityObject();
        if (schema.getPermitAllPoints() != null) {
            schema.getPermitAllPoints().stream().filter(ap -> ap instanceof N2oUrlAccessPoint && ((N2oUrlAccessPoint)ap).getMatcher().matches(url)).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
                if (list.size() == 1) {
                    securityObject.setPermitAll(true);
                }
                return list;
            }));
        }
        if (schema.getAuthenticatedPoints() != null) {
            schema.getAuthenticatedPoints().stream().filter(ap -> ap instanceof N2oUrlAccessPoint && ((N2oUrlAccessPoint)ap).getMatcher().matches(url)).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
                if (list.size() == 1) {
                    securityObject.setAuthenticated(true);
                }
                return list;
            }));
        }
        if (schema.getAnonymousPoints() != null) {
            schema.getAnonymousPoints().stream().filter(ap -> ap instanceof N2oUrlAccessPoint && ((N2oUrlAccessPoint)ap).getMatcher().matches(url)).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
                if (list.size() == 1) {
                    securityObject.setAnonymous(true);
                }
                return list;
            }));
        }
        if ((roles = PermissionAndRoleCollector.collectRoles(N2oUrlAccessPoint.class, PermissionAndRoleCollector.URL_ACCESS.apply(url), schema)) != null && roles.size() > 0) {
            securityObject.setRoles(roles.stream().map(N2oRole::getId).collect(Collectors.toSet()));
        }
        if ((permissions = PermissionAndRoleCollector.collectPermission(N2oUrlAccessPoint.class, PermissionAndRoleCollector.URL_ACCESS.apply(url), schema)) != null && permissions.size() > 0) {
            securityObject.setPermissions(permissions.stream().map(N2oPermission::getId).collect(Collectors.toSet()));
        }
        if ((userAccesses = PermissionAndRoleCollector.collectUsers(N2oUrlAccessPoint.class, PermissionAndRoleCollector.URL_ACCESS.apply(url), schema)) != null && userAccesses.size() > 0) {
            securityObject.setUsernames(userAccesses.stream().map(N2oUserAccess::getId).collect(Collectors.toSet()));
        }
        if (securityObject.isEmpty()) {
            Boolean defaultUrlAccessDenied = (Boolean)p.resolve(Placeholders.property((String)DEFAULT_URL_ACCESS_DENIED), Boolean.class);
            securityObject.setPermitAll(defaultUrlAccessDenied == false);
            securityObject.setDenied(defaultUrlAccessDenied);
        }
        security.getSecurityMap().put("url", securityObject);
    }

    private Security getSecurity(PropertiesAware compiled) {
        if (compiled.getProperties() == null) {
            compiled.setProperties(new HashMap());
        }
        if (compiled.getProperties().get(Security.SECURITY_PROP_NAME) == null) {
            compiled.getProperties().put(Security.SECURITY_PROP_NAME, new Security());
        }
        return (Security)compiled.getProperties().get(Security.SECURITY_PROP_NAME);
    }

    protected void transfer(PropertiesAware from, PropertiesAware to) {
        if (from == null || from.getProperties() == null) {
            return;
        }
        Map properties = from.getProperties();
        if (properties == null || properties.get(Security.SECURITY_PROP_NAME) == null || to.getProperties() != null && to.getProperties().containsKey(Security.SECURITY_PROP_NAME)) {
            return;
        }
        if (to.getProperties() == null) {
            to.setProperties(new HashMap());
        }
        to.getProperties().put(Security.SECURITY_PROP_NAME, properties.get(Security.SECURITY_PROP_NAME));
    }

    protected void merge(PropertiesAware destination, List<? extends PropertiesAware> sources) {
        if (destination == null || sources == null) {
            return;
        }
        HashMap securityObjects = new HashMap();
        for (PropertiesAware propertiesAware : sources) {
            Security sourceSecurity;
            if (propertiesAware.getProperties() == null || !propertiesAware.getProperties().containsKey(Security.SECURITY_PROP_NAME) || (sourceSecurity = (Security)propertiesAware.getProperties().get(Security.SECURITY_PROP_NAME)).getSecurityMap() == null || sourceSecurity.getSecurityMap().isEmpty()) continue;
            for (String securityObjectKey : sourceSecurity.getSecurityMap().keySet()) {
                if (!securityObjects.containsKey(securityObjectKey)) {
                    securityObjects.put(securityObjectKey, new ArrayList());
                }
                ((List)securityObjects.get(securityObjectKey)).add(sourceSecurity.getSecurityMap().get(securityObjectKey));
            }
        }
        Security security = new Security();
        security.setSecurityMap(new HashMap<String, Security.SecurityObject>());
        for (Map.Entry securityEntry : securityObjects.entrySet()) {
            Security.SecurityObject securityObject = new Security.SecurityObject();
            if (((List)securityEntry.getValue()).size() == sources.size()) {
                this.mergeSecurityObjects(securityObject, (List)securityEntry.getValue());
            }
            if (securityObject.isEmpty()) continue;
            security.getSecurityMap().put((String)securityEntry.getKey(), securityObject);
        }
        if (!security.getSecurityMap().isEmpty()) {
            if (destination.getProperties() == null) {
                destination.setProperties(new HashMap());
            }
            destination.getProperties().put(Security.SECURITY_PROP_NAME, security);
        }
    }

    protected void collectObjectFilters(PropertiesAware compiled, String objectId, String operationId, SimpleCompiledAccessSchema schema) {
        if (objectId == null) {
            return;
        }
        if (compiled.getProperties() == null) {
            compiled.setProperties(new HashMap());
        }
        if (compiled.getProperties().get(SecurityFilters.SECURITY_FILTERS_PROP_NAME) == null) {
            compiled.getProperties().put(SecurityFilters.SECURITY_FILTERS_PROP_NAME, new SecurityFilters());
        }
        SecurityFilters securityFilters = (SecurityFilters)compiled.getProperties().get(SecurityFilters.SECURITY_FILTERS_PROP_NAME);
        this.collectFilters(objectId, schema, securityFilters);
        this.collectRemoveFilters(objectId, operationId, schema, securityFilters);
    }

    private void collectRemoveFilters(String objectId, String operationId, SimpleCompiledAccessSchema schema, SecurityFilters securityFilters) {
        if (schema.getN2oRoles() != null) {
            HashMap<String, Set<String>> removeRoleFilters = new HashMap<String, Set<String>>();
            schema.getN2oRoles().stream().filter(r -> r.getAccessPoints() != null).forEach(r -> this.collectRemoveFilters(objectId, operationId, removeRoleFilters, r.getAccessPoints(), r.getId()));
            if (!removeRoleFilters.isEmpty()) {
                securityFilters.setRemoveRoleFilters(removeRoleFilters);
            }
        }
        if (schema.getN2oPermissions() != null) {
            HashMap<String, Set<String>> removePermissionFilters = new HashMap<String, Set<String>>();
            schema.getN2oPermissions().stream().filter(r -> r.getAccessPoints() != null).forEach(r -> this.collectRemoveFilters(objectId, operationId, removePermissionFilters, r.getAccessPoints(), r.getId()));
            if (!removePermissionFilters.isEmpty()) {
                securityFilters.setRemovePermissionFilters(removePermissionFilters);
            }
        }
        if (schema.getN2oUserAccesses() != null) {
            HashMap<String, Set<String>> removeUserFilters = new HashMap<String, Set<String>>();
            schema.getN2oUserAccesses().stream().filter(r -> r.getAccessPoints() != null).forEach(r -> this.collectRemoveFilters(objectId, operationId, removeUserFilters, r.getAccessPoints(), r.getId()));
            if (!removeUserFilters.isEmpty()) {
                securityFilters.setRemoveUserFilters(removeUserFilters);
            }
        }
        if (schema.getAuthenticatedPoints() != null) {
            securityFilters.setRemoveAuthenticatedFilters(this.collectRemoveFilters(objectId, operationId, schema.getAuthenticatedPoints()));
        }
        if (schema.getAnonymousPoints() != null) {
            securityFilters.setRemoveAnonymousFilters(this.collectRemoveFilters(objectId, operationId, schema.getAnonymousPoints()));
        }
        if (schema.getPermitAllPoints() != null) {
            securityFilters.setRemovePermitAllFilters(this.collectRemoveFilters(objectId, operationId, schema.getPermitAllPoints()));
        }
    }

    private Set<String> collectRemoveFilters(String objectId, String operationId, List<AccessPoint> accessPoints) {
        return accessPoints == null ? null : accessPoints.stream().filter(ap -> this.checkByObjectAndOperation(objectId, operationId, (AccessPoint)ap)).flatMap(ap -> Stream.of(((N2oObjectAccessPoint)ap).getRemoveFilters())).collect(Collectors.toSet());
    }

    private void collectRemoveFilters(String objectId, String operationId, Map<String, Set<String>> removePermissionFilters, AccessPoint[] accessPoints, String id) {
        if (accessPoints == null) {
            return;
        }
        HashSet<String> rf = new HashSet<String>();
        for (AccessPoint ap : accessPoints) {
            if (!this.checkByObjectAndOperation(objectId, operationId, ap)) continue;
            rf.addAll(Arrays.asList(((N2oObjectAccessPoint)ap).getRemoveFilters()));
        }
        if (!rf.isEmpty()) {
            removePermissionFilters.put(id, rf);
        }
    }

    private void collectFilters(String objectId, SimpleCompiledAccessSchema schema, SecurityFilters securityFilters) {
        if (schema.getN2oRoles() != null) {
            HashMap<String, List<N2oObjectFilter>> roleFilters = new HashMap<String, List<N2oObjectFilter>>();
            schema.getN2oRoles().stream().filter(r -> r.getAccessPoints() != null).forEach(r -> this.collectFiltersFromAccessPoints(objectId, roleFilters, r.getAccessPoints(), r.getId()));
            if (!roleFilters.isEmpty()) {
                securityFilters.setRoleFilters(roleFilters);
            }
        }
        if (schema.getN2oPermissions() != null) {
            HashMap<String, List<N2oObjectFilter>> permissionFilters = new HashMap<String, List<N2oObjectFilter>>();
            schema.getN2oPermissions().stream().filter(p -> p.getAccessPoints() != null).forEach(p -> this.collectFiltersFromAccessPoints(objectId, permissionFilters, p.getAccessPoints(), p.getId()));
            if (!permissionFilters.isEmpty()) {
                securityFilters.setPermissionFilters(permissionFilters);
            }
        }
        if (schema.getN2oUserAccesses() != null) {
            HashMap<String, List<N2oObjectFilter>> userFilters = new HashMap<String, List<N2oObjectFilter>>();
            schema.getN2oUserAccesses().stream().filter(u -> u.getAccessPoints() != null).forEach(u -> this.collectFiltersFromAccessPoints(objectId, userFilters, u.getAccessPoints(), u.getId()));
            if (!userFilters.isEmpty()) {
                securityFilters.setUserFilters(userFilters);
            }
        }
        if (schema.getAuthenticatedPoints() != null) {
            securityFilters.setAuthenticatedFilters(this.collectFiltersFromAccessPointList(objectId, schema.getAuthenticatedPoints()));
        }
        if (schema.getAnonymousPoints() != null) {
            securityFilters.setAnonymousFilters(this.collectFiltersFromAccessPointList(objectId, schema.getAnonymousPoints()));
        }
        if (schema.getPermitAllPoints() != null) {
            securityFilters.setPermitAllFilters(this.collectFiltersFromAccessPointList(objectId, schema.getPermitAllPoints()));
        }
    }

    private List<N2oObjectFilter> collectFiltersFromAccessPointList(String objectId, List<AccessPoint> accessPoints) {
        return accessPoints == null ? null : accessPoints.stream().filter(ap -> this.checkByObject(objectId, (AccessPoint)ap)).flatMap(ap -> Stream.of(((N2oObjectFiltersAccessPoint)ap).getFilters())).collect(Collectors.toList());
    }

    private void collectFiltersFromAccessPoints(String objectId, Map<String, List<N2oObjectFilter>> filters, AccessPoint[] accessPoints, String id) {
        for (AccessPoint ap : accessPoints) {
            if (!this.checkByObject(objectId, ap)) continue;
            filters.put(id, Arrays.asList(((N2oObjectFiltersAccessPoint)ap).getFilters()));
        }
    }

    private boolean checkByObject(String objectId, AccessPoint ap) {
        return ap instanceof N2oObjectFiltersAccessPoint && StringUtils.maskMatch((String)((N2oObjectFiltersAccessPoint)ap).getObjectId(), (String)objectId) && ((N2oObjectFiltersAccessPoint)ap).getFilters() != null;
    }

    private boolean checkByObjectAndOperation(String objectId, String operationId, AccessPoint ap) {
        return ap instanceof N2oObjectAccessPoint && StringUtils.maskMatch((String)((N2oObjectAccessPoint)ap).getObjectId(), (String)objectId) && (operationId == null || StringUtils.maskMatch((String)((N2oObjectAccessPoint)ap).getAction(), (String)operationId)) && ((N2oObjectAccessPoint)ap).getRemoveFilters() != null;
    }

    private void mergeSecurityObjects(Security.SecurityObject destination, List<Security.SecurityObject> sources) {
        boolean permitAll = false;
        boolean denied = true;
        boolean anonymous = false;
        boolean authenticated = false;
        for (Security.SecurityObject source : sources) {
            denied = source.getDenied() != null && source.getDenied() != false && denied;
            permitAll = source.getPermitAll() != null && source.getPermitAll() != false || permitAll;
            anonymous = source.getAnonymous() != null && source.getAnonymous() != false || anonymous;
            boolean bl = authenticated = source.getAuthenticated() != null && source.getAuthenticated() != false || authenticated;
            if (source.getUsernames() != null) {
                if (destination.getUsernames() == null) {
                    destination.setUsernames(new HashSet<String>());
                }
                destination.getUsernames().addAll(source.getUsernames());
            }
            if (source.getPermissions() != null) {
                if (destination.getPermissions() == null) {
                    destination.setPermissions(new HashSet<String>());
                }
                destination.getPermissions().addAll(source.getPermissions());
            }
            if (source.getRoles() == null) continue;
            if (destination.getRoles() == null) {
                destination.setRoles(new HashSet<String>());
            }
            destination.getRoles().addAll(source.getRoles());
        }
        if (permitAll) {
            destination.setPermitAll(true);
        } else if (authenticated || anonymous) {
            destination.setAnonymous(anonymous);
            destination.setAuthenticated(authenticated);
        } else if (denied) {
            destination.setDenied(true);
        }
    }
}

