/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.access.integration.metadata.transform;

import net.n2oapp.framework.access.integration.metadata.transform.BaseAccessTransformer;
import net.n2oapp.framework.access.metadata.schema.AccessContext;
import net.n2oapp.framework.access.metadata.schema.simple.SimpleCompiledAccessSchema;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.aware.PropertiesAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.page.N2oPage;
import net.n2oapp.framework.api.metadata.header.CompiledHeader;
import net.n2oapp.framework.api.metadata.header.HeaderItem;
import net.n2oapp.framework.api.metadata.header.SimpleMenu;
import net.n2oapp.framework.config.metadata.compile.context.HeaderContext;
import org.springframework.stereotype.Component;

@Component
public class HeaderAccessTransformer
extends BaseAccessTransformer<CompiledHeader, HeaderContext> {
    public Class<? extends Compiled> getCompiledClass() {
        return CompiledHeader.class;
    }

    public CompiledHeader transform(CompiledHeader compiled, HeaderContext context, CompileProcessor p) {
        SimpleCompiledAccessSchema accessSchema = (SimpleCompiledAccessSchema)p.getCompiled((CompileContext)new AccessContext((String)p.resolve(Placeholders.property((String)"n2o.access.schema.id"), String.class)));
        this.mapSecurity(compiled, accessSchema, p);
        return compiled;
    }

    private void mapSecurity(CompiledHeader compiled, SimpleCompiledAccessSchema schema, CompileProcessor p) {
        this.mapSecurityItems(compiled.getItems(), schema, p);
        this.mapSecurityItems(compiled.getExtraItems(), schema, p);
    }

    private void mapSecurityItems(SimpleMenu items, SimpleCompiledAccessSchema schema, CompileProcessor p) {
        for (HeaderItem item : items) {
            if (item.getSubItems() == null) {
                this.mapSecurityItem(schema, p, item);
                continue;
            }
            item.getSubItems().forEach(si -> this.mapSecurityItem(schema, p, (HeaderItem)si));
        }
    }

    private void mapSecurityItem(SimpleCompiledAccessSchema schema, CompileProcessor p, HeaderItem si) {
        this.collectPageAccess((PropertiesAware)si, si.getPageId(), schema, p);
        if (si.getPageId() != null) {
            String objectId = ((N2oPage)p.getSource(si.getPageId(), N2oPage.class)).getObjectId();
            this.collectObjectAccess((PropertiesAware)si, objectId, null, schema, p);
        }
    }
}

