/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.access.integration.metadata.transform;

import net.n2oapp.framework.access.integration.metadata.transform.BaseAccessTransformer;
import net.n2oapp.framework.access.metadata.schema.AccessContext;
import net.n2oapp.framework.access.metadata.schema.simple.SimpleCompiledAccessSchema;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.aware.PropertiesAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.config.metadata.compile.context.ObjectContext;
import org.springframework.stereotype.Component;

@Component
public class ObjectAccessTransformer
extends BaseAccessTransformer<CompiledObject, ObjectContext> {
    public CompiledObject transform(CompiledObject compiled, ObjectContext context, CompileProcessor p) {
        SimpleCompiledAccessSchema accessSchema = (SimpleCompiledAccessSchema)p.getCompiled((CompileContext)new AccessContext((String)p.resolve(Placeholders.property((String)"n2o.access.schema.id"), String.class)));
        this.mapSecurity(accessSchema, compiled);
        return compiled;
    }

    private void mapSecurity(SimpleCompiledAccessSchema schema, CompiledObject compiled) {
        for (CompiledObject.Operation operation : compiled.getOperations().values()) {
            this.mapObjectAccess(schema, operation, compiled.getId());
        }
    }

    private void mapObjectAccess(SimpleCompiledAccessSchema schema, CompiledObject.Operation compiled, String objectId) {
        this.collectObjectAccess((PropertiesAware)compiled, objectId, compiled.getId(), schema);
        this.collectObjectFilters((PropertiesAware)compiled, objectId, compiled.getId(), schema);
    }

    public Class<? extends Compiled> getCompiledClass() {
        return CompiledObject.class;
    }
}

