/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.access.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.criteria.filters.Filter;
import net.n2oapp.framework.access.exception.AccessDeniedException;
import net.n2oapp.framework.access.exception.UnauthorizedException;
import net.n2oapp.framework.access.metadata.Security;
import net.n2oapp.framework.access.metadata.SecurityFilters;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oObjectFilter;
import net.n2oapp.framework.access.simple.PermissionApi;
import net.n2oapp.framework.api.context.Context;
import net.n2oapp.framework.api.context.ContextProcessor;
import net.n2oapp.framework.api.criteria.Restriction;
import net.n2oapp.framework.api.user.UserContext;

public class SecurityProvider {
    private PermissionApi permissionApi;

    public SecurityProvider(PermissionApi permissionApi) {
        this.permissionApi = permissionApi;
    }

    public void checkAccess(Security security, UserContext userContext) {
        if (security == null || security.getSecurityMap() == null) {
            return;
        }
        for (Security.SecurityObject securityObject : security.getSecurityMap().values()) {
            this.check(userContext, securityObject);
        }
    }

    public List<Restriction> collectRestrictions(SecurityFilters securityFilters, UserContext userContext) {
        if (securityFilters == null) {
            return Collections.emptyList();
        }
        HashSet<N2oObjectFilter> filters = new HashSet<N2oObjectFilter>();
        HashSet<String> removeFilters = new HashSet<String>();
        if (securityFilters.getPermitAllFilters() != null) {
            filters.addAll(securityFilters.getPermitAllFilters());
        }
        if (securityFilters.getRemovePermitAllFilters() != null) {
            removeFilters.addAll(securityFilters.getRemovePermitAllFilters());
        }
        if (this.permissionApi.hasAuthentication(userContext)) {
            if (securityFilters.getAuthenticatedFilters() != null) {
                filters.addAll(securityFilters.getAuthenticatedFilters());
            }
            if (securityFilters.getRemoveAuthenticatedFilters() != null) {
                removeFilters.addAll(securityFilters.getRemoveAuthenticatedFilters());
            }
        } else {
            if (securityFilters.getAnonymousFilters() != null) {
                filters.addAll(securityFilters.getAnonymousFilters());
            }
            if (securityFilters.getRemoveAnonymousFilters() != null) {
                removeFilters.addAll(securityFilters.getRemoveAnonymousFilters());
            }
        }
        if (securityFilters.getRoleFilters() != null) {
            securityFilters.getRoleFilters().keySet().stream().filter(r -> this.permissionApi.hasRole(userContext, (String)r)).forEach(r -> filters.addAll((Collection)securityFilters.getRoleFilters().get(r)));
        }
        if (securityFilters.getRemoveRoleFilters() != null) {
            securityFilters.getRemoveRoleFilters().keySet().stream().filter(r -> this.permissionApi.hasRole(userContext, (String)r)).forEach(r -> removeFilters.addAll((Collection)securityFilters.getRemoveRoleFilters().get(r)));
        }
        if (securityFilters.getPermissionFilters() != null) {
            securityFilters.getPermissionFilters().keySet().stream().filter(p -> this.permissionApi.hasPermission(userContext, (String)p)).forEach(p -> filters.addAll((Collection)securityFilters.getPermissionFilters().get(p)));
        }
        if (securityFilters.getRemovePermissionFilters() != null) {
            securityFilters.getRemovePermissionFilters().keySet().stream().filter(p -> this.permissionApi.hasPermission(userContext, (String)p)).forEach(p -> removeFilters.addAll((Collection)securityFilters.getRemovePermissionFilters().get(p)));
        }
        if (securityFilters.getUserFilters() != null) {
            securityFilters.getUserFilters().keySet().stream().filter(u -> this.permissionApi.hasUsername(userContext, (String)u)).forEach(u -> filters.addAll((Collection)securityFilters.getUserFilters().get(u)));
        }
        if (securityFilters.getRemoveUserFilters() != null) {
            securityFilters.getRemoveUserFilters().keySet().stream().filter(u -> this.permissionApi.hasUsername(userContext, (String)u)).forEach(u -> removeFilters.addAll((Collection)securityFilters.getRemoveUserFilters().get(u)));
        }
        filters.removeIf(f -> removeFilters.contains(f.getId()));
        return filters.stream().map(this::restriction).collect(Collectors.toList());
    }

    private Restriction restriction(N2oObjectFilter filter) {
        Object value = filter.isArray() ? Arrays.asList(filter.getValues()) : filter.getValue();
        return new Restriction(filter.getFieldId(), value, filter.getType());
    }

    public void checkRestrictions(DataSet data, SecurityFilters securityFilters, UserContext userContext) {
        List<Restriction> restrictions = this.collectRestrictions(securityFilters, userContext);
        ContextProcessor contextProcessor = new ContextProcessor((Context)userContext);
        for (Restriction securityRestriction : restrictions) {
            Filter securityFilter;
            Object filterValue;
            Object realValue = data.get((Object)securityRestriction.getFieldId());
            if (realValue == null || (filterValue = contextProcessor.resolve(securityRestriction.getValue())) == null || (securityFilter = new Filter(filterValue, securityRestriction.getType())).check(realValue)) continue;
            throw new AccessDeniedException("Access denied by field " + securityRestriction.getFieldId());
        }
    }

    private void check(UserContext userContext, Security.SecurityObject securityObject) {
        if (securityObject.getDenied() != null && securityObject.getDenied().booleanValue()) {
            throw new UnauthorizedException();
        }
        if (securityObject.getPermitAll() != null && securityObject.getPermitAll().booleanValue()) {
            return;
        }
        if (!this.permissionApi.hasAuthentication(userContext)) {
            if (securityObject.getAnonymous() != null && securityObject.getAnonymous().booleanValue()) {
                return;
            }
            throw new UnauthorizedException();
        }
        if (securityObject.getAuthenticated() != null && securityObject.getAuthenticated().booleanValue()) {
            return;
        }
        if (securityObject.getAnonymous() != null && securityObject.getAnonymous().booleanValue()) {
            throw new AccessDeniedException();
        }
        if (!this.checkAccessList(userContext, securityObject.getRoles(), this.permissionApi::hasRole)) {
            if (!this.checkAccessList(userContext, securityObject.getPermissions(), this.permissionApi::hasPermission)) {
                if (!this.checkAccessList(userContext, securityObject.getUsernames(), this.permissionApi::hasUsername)) {
                    throw new AccessDeniedException();
                }
            }
        }
    }

    private boolean checkAccessList(UserContext userContext, Set<String> accessList, BiPredicate<UserContext, String> f) {
        if (accessList == null) {
            return false;
        }
        for (String param : accessList) {
            if (!f.test(userContext, param)) continue;
            return true;
        }
        return false;
    }
}

