/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.access.metadata.schema.simple;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import lombok.Generated;
import net.n2oapp.framework.access.metadata.accesspoint.AccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oColumnAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oContainerAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oFilterAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oMenuItemAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oModuleAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oObjectAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oPageAccessPoint;
import net.n2oapp.framework.api.metadata.local.util.CompileUtil;

public class ReproducerAccessPoint {
    public static void reproduceAccessPoint(N2oObjectAccessPoint accessPoint, List<AccessPoint> pointList) {
        ReproducerAccessPoint.split(accessPoint, accessPoint.getAction(), N2oObjectAccessPoint::setAction, pointList);
    }

    public static void reproduceAccessPoint(N2oModuleAccessPoint accessPoint, List<AccessPoint> pointList) {
        ReproducerAccessPoint.split(accessPoint, accessPoint.getModule(), N2oModuleAccessPoint::setModule, pointList);
    }

    public static void reproduceAccessPoint(N2oPageAccessPoint accessPoint, List<AccessPoint> pointList) {
        ReproducerAccessPoint.split(accessPoint, accessPoint.getPage(), N2oPageAccessPoint::setPage, pointList);
    }

    public static void reproduceAccessPoint(N2oContainerAccessPoint accessPoint, List<AccessPoint> pointList) {
        ReproducerAccessPoint.split(accessPoint, accessPoint.getContainer(), N2oContainerAccessPoint::setContainer, pointList);
    }

    public static void reproduceAccessPoint(N2oMenuItemAccessPoint accessPoint, List<AccessPoint> pointList) {
        ReproducerAccessPoint.split(accessPoint, accessPoint.getMenuItem(), N2oMenuItemAccessPoint::setMenuItem, pointList);
    }

    public static void reproduceAccessPoint(N2oColumnAccessPoint accessPoint, List<AccessPoint> pointList) {
        ReproducerAccessPoint.split(accessPoint, accessPoint.getColumnId(), N2oColumnAccessPoint::setColumnId, pointList);
    }

    public static void reproduceAccessPoint(N2oFilterAccessPoint accessPoint, List<AccessPoint> pointList) {
        ReproducerAccessPoint.split(accessPoint, accessPoint.getFilterId(), N2oFilterAccessPoint::setFilterId, pointList);
    }

    private static <T extends AccessPoint> void split(T accessPoint, String val, BiConsumer<T, String> setter, List<AccessPoint> pointList) {
        if (val != null && val.contains(",")) {
            String[] split = val.replaceAll("\\s+", "").split(",");
            List<AccessPoint> list = Arrays.stream(split).map(str -> {
                AccessPoint point = (AccessPoint)CompileUtil.copy((Object)accessPoint);
                setter.accept((Object)point, (String)str);
                return point;
            }).toList();
            pointList.remove(accessPoint);
            pointList.addAll(list);
        }
    }

    @Generated
    private ReproducerAccessPoint() {
    }
}

