/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.access.metadata.compile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.n2oapp.framework.access.functions.StreamUtil;
import net.n2oapp.framework.access.metadata.accesspoint.AccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oColumnAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oContainerAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oFilterAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oMenuItemAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oModuleAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oObjectAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oPageAccessPoint;
import net.n2oapp.framework.access.metadata.compile.AccessSchemaCompiler;
import net.n2oapp.framework.access.metadata.schema.AccessContext;
import net.n2oapp.framework.access.metadata.schema.permission.N2oPermission;
import net.n2oapp.framework.access.metadata.schema.role.N2oRole;
import net.n2oapp.framework.access.metadata.schema.simple.N2oSimpleAccessSchema;
import net.n2oapp.framework.access.metadata.schema.simple.ReproducerAccessPoint;
import net.n2oapp.framework.access.metadata.schema.simple.SimpleCompiledAccessSchema;
import net.n2oapp.framework.access.metadata.schema.user.N2oUserAccess;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import org.springframework.stereotype.Component;

@Component
public class SimpleAccessSchemaCompiler
extends AccessSchemaCompiler<SimpleCompiledAccessSchema, N2oSimpleAccessSchema> {
    public Class<? extends Source> getSourceClass() {
        return N2oSimpleAccessSchema.class;
    }

    public SimpleCompiledAccessSchema compile(N2oSimpleAccessSchema source, AccessContext context, CompileProcessor p) {
        SimpleCompiledAccessSchema compiled = new SimpleCompiledAccessSchema();
        this.compileAccess(compiled, source);
        if (source.getN2oPermissions() != null) {
            this.reproduce(source.getN2oPermissions(), N2oPermission::getAccessPoints, N2oPermission::setAccessPoints);
            compiled.setN2oPermissions(Arrays.asList(source.getN2oPermissions()));
        }
        if (source.getN2oRoles() != null) {
            this.reproduce(source.getN2oRoles(), N2oRole::getAccessPoints, N2oRole::setAccessPoints);
            compiled.setN2oRoles(Arrays.asList(source.getN2oRoles()));
        }
        if (source.getPermitAllPoints() != null) {
            compiled.setPermitAllPoints(this.reproduceAccessPoints(source.getPermitAllPoints()));
        }
        if (source.getAuthenticatedPoints() != null) {
            compiled.setAuthenticatedPoints(this.reproduceAccessPoints(source.getAuthenticatedPoints()));
        }
        if (source.getN2oUserAccesses() != null) {
            this.reproduce(source.getN2oUserAccesses(), N2oUserAccess::getAccessPoints, N2oUserAccess::setAccessPoints);
            compiled.setN2oUserAccesses(Arrays.asList(source.getN2oUserAccesses()));
        }
        if (source.getAnonymousPoints() != null) {
            compiled.setAnonymousPoints(this.reproduceAccessPoints(source.getAnonymousPoints()));
        }
        return compiled;
    }

    private <T> void reproduce(T[] val, Function<T, AccessPoint[]> getter, BiConsumer<T, AccessPoint[]> setter) {
        StreamUtil.safeStreamOf(val).forEach(v -> {
            List<AccessPoint> accessPoints = this.reproduceAccessPoints((AccessPoint[])getter.apply(v));
            setter.accept(v, accessPoints.toArray(new AccessPoint[accessPoints.size()]));
        });
    }

    private List<AccessPoint> reproduceAccessPoints(AccessPoint[] points) {
        if (points == null) {
            return Collections.emptyList();
        }
        ArrayList<AccessPoint> accessPoints = new ArrayList<AccessPoint>(Arrays.asList(points));
        Arrays.stream(points).forEach(ac -> this.reproduceAccessPoint((AccessPoint)ac, (List<AccessPoint>)accessPoints));
        return accessPoints;
    }

    private void reproduceAccessPoint(AccessPoint accessPoint, List<AccessPoint> pointList) {
        if (accessPoint instanceof N2oObjectAccessPoint) {
            N2oObjectAccessPoint ap = (N2oObjectAccessPoint)accessPoint;
            ReproducerAccessPoint.reproduceAccessPoint(ap, pointList);
        } else if (accessPoint instanceof N2oModuleAccessPoint) {
            N2oModuleAccessPoint moduleAccessPoint = (N2oModuleAccessPoint)accessPoint;
            ReproducerAccessPoint.reproduceAccessPoint(moduleAccessPoint, pointList);
        } else if (accessPoint instanceof N2oPageAccessPoint) {
            N2oPageAccessPoint pageAccessPoint = (N2oPageAccessPoint)accessPoint;
            ReproducerAccessPoint.reproduceAccessPoint(pageAccessPoint, pointList);
        } else if (accessPoint instanceof N2oContainerAccessPoint) {
            N2oContainerAccessPoint containerAccessPoint = (N2oContainerAccessPoint)accessPoint;
            ReproducerAccessPoint.reproduceAccessPoint(containerAccessPoint, pointList);
        } else if (accessPoint instanceof N2oMenuItemAccessPoint) {
            N2oMenuItemAccessPoint menuItemAccessPoint = (N2oMenuItemAccessPoint)accessPoint;
            ReproducerAccessPoint.reproduceAccessPoint(menuItemAccessPoint, pointList);
        } else if (accessPoint instanceof N2oColumnAccessPoint) {
            N2oColumnAccessPoint columnAccessPoint = (N2oColumnAccessPoint)accessPoint;
            ReproducerAccessPoint.reproduceAccessPoint(columnAccessPoint, pointList);
        } else if (accessPoint instanceof N2oFilterAccessPoint) {
            N2oFilterAccessPoint filterAccessPoint = (N2oFilterAccessPoint)accessPoint;
            ReproducerAccessPoint.reproduceAccessPoint(filterAccessPoint, pointList);
        }
    }
}

