/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.access.integration.metadata.transform;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.n2oapp.framework.access.metadata.Security;
import net.n2oapp.framework.access.metadata.SecurityFilters;
import net.n2oapp.framework.access.metadata.SecurityObject;
import net.n2oapp.framework.access.metadata.accesspoint.AccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oObjectAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oObjectFilter;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oObjectFiltersAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oPageAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oUrlAccessPoint;
import net.n2oapp.framework.access.metadata.schema.permission.N2oPermission;
import net.n2oapp.framework.access.metadata.schema.role.N2oRole;
import net.n2oapp.framework.access.metadata.schema.simple.SimpleCompiledAccessSchema;
import net.n2oapp.framework.access.metadata.schema.user.N2oUserAccess;
import net.n2oapp.framework.access.simple.PermissionAndRoleCollector;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.aware.CompiledClassAware;
import net.n2oapp.framework.api.metadata.aware.PropertiesAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.CompileTransformer;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public abstract class BaseAccessTransformer<D extends Compiled, C extends CompileContext<?, ?>>
implements CompileTransformer<D, C>,
CompiledClassAware {
    private static final String DEFAULT_OBJECT_ACCESS_DENIED = "n2o.access.deny_objects";
    private static final String DEFAULT_PAGE_ACCESS_DENIED = "n2o.access.deny_pages";
    private static final String DEFAULT_URL_ACCESS_DENIED = "n2o.access.deny_urls";
    private static final String CUSTOM = "custom";

    protected void collectObjectAccess(PropertiesAware compiled, String objectId, String operationId, SimpleCompiledAccessSchema schema, CompileProcessor p) {
        List<N2oRole> roles;
        List<N2oPermission> permissions;
        List<N2oUserAccess> userAccesses;
        if (Objects.isNull(objectId)) {
            return;
        }
        Security security = this.getSecurity(compiled);
        SecurityObject securityObject = new SecurityObject();
        if (CollectionUtils.isNotEmpty((Collection)security) && (Objects.nonNull(((Map)security.get(0)).get("object")) || Objects.nonNull(((Map)security.get(0)).get(CUSTOM)))) {
            return;
        }
        if (Objects.nonNull(schema.getPermitAllPoints())) {
            schema.getPermitAllPoints().stream().filter(ap -> {
                N2oObjectAccessPoint n2oObjectAccessPoint;
                return ap instanceof N2oObjectAccessPoint && StringUtils.maskMatch((String)(n2oObjectAccessPoint = (N2oObjectAccessPoint)ap).getObjectId(), (String)objectId) && (Objects.isNull(operationId) || StringUtils.maskMatch((String)n2oObjectAccessPoint.getAction(), (String)operationId));
            }).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    securityObject.setPermitAll(true);
                }
                return list;
            }));
        }
        if (Objects.nonNull(schema.getAuthenticatedPoints())) {
            schema.getAuthenticatedPoints().stream().filter(ap -> {
                N2oObjectAccessPoint n2oObjectAccessPoint;
                return ap instanceof N2oObjectAccessPoint && StringUtils.maskMatch((String)(n2oObjectAccessPoint = (N2oObjectAccessPoint)ap).getObjectId(), (String)objectId) && (Objects.isNull(operationId) || StringUtils.maskMatch((String)n2oObjectAccessPoint.getAction(), (String)operationId));
            }).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    securityObject.setAuthenticated(true);
                }
                return list;
            }));
        }
        if (Objects.nonNull(schema.getAnonymousPoints())) {
            schema.getAnonymousPoints().stream().filter(ap -> {
                N2oObjectAccessPoint n2oObjectAccessPoint;
                return ap instanceof N2oObjectAccessPoint && StringUtils.maskMatch((String)(n2oObjectAccessPoint = (N2oObjectAccessPoint)ap).getObjectId(), (String)objectId) && (Objects.isNull(operationId) || StringUtils.maskMatch((String)n2oObjectAccessPoint.getAction(), (String)operationId));
            }).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    securityObject.setAnonymous(true);
                }
                return list;
            }));
        }
        if (CollectionUtils.isNotEmpty(userAccesses = PermissionAndRoleCollector.collectUsers(N2oObjectAccessPoint.class, PermissionAndRoleCollector.OBJECT_ACCESS.apply(objectId, operationId), schema))) {
            securityObject.setUsernames(userAccesses.stream().map(N2oUserAccess::getId).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(permissions = PermissionAndRoleCollector.collectPermission(N2oObjectAccessPoint.class, PermissionAndRoleCollector.OBJECT_ACCESS.apply(objectId, operationId), schema))) {
            securityObject.setPermissions(permissions.stream().map(N2oPermission::getId).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(roles = PermissionAndRoleCollector.collectRoles(N2oObjectAccessPoint.class, PermissionAndRoleCollector.OBJECT_ACCESS.apply(objectId, operationId), schema))) {
            securityObject.setRoles(roles.stream().map(N2oRole::getId).collect(Collectors.toSet()));
        }
        if (securityObject.isEmpty()) {
            Boolean defaultObjectAccessDenied = (Boolean)p.resolve(Placeholders.property((String)DEFAULT_OBJECT_ACCESS_DENIED), Boolean.class);
            securityObject.setPermitAll(defaultObjectAccessDenied == false);
            securityObject.setDenied(defaultObjectAccessDenied);
        }
        if (security.isEmpty()) {
            security.add(new HashMap());
        }
        ((Map)security.get(0)).put("object", securityObject);
    }

    protected void collectPageAccess(PropertiesAware compiled, String pageId, SimpleCompiledAccessSchema schema, CompileProcessor p) {
        List<N2oUserAccess> userAccesses;
        List<N2oPermission> permissions;
        List<N2oRole> roles;
        if (Objects.isNull(pageId)) {
            return;
        }
        String originPageId = pageId.split("\\?")[0];
        Security security = this.getSecurity(compiled);
        if (CollectionUtils.isNotEmpty((Collection)security) && (Objects.nonNull(((Map)security.get(0)).get("page")) || Objects.nonNull(((Map)security.get(0)).get(CUSTOM)))) {
            return;
        }
        SecurityObject securityObject = new SecurityObject();
        if (Objects.nonNull(schema.getPermitAllPoints())) {
            schema.getPermitAllPoints().stream().filter(ap -> {
                N2oPageAccessPoint n2oPageAccessPoint;
                return ap instanceof N2oPageAccessPoint && (n2oPageAccessPoint = (N2oPageAccessPoint)ap).getPage().equals(originPageId);
            }).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
                if (list.size() == 1) {
                    securityObject.setPermitAll(true);
                }
                return list;
            }));
        }
        if (Objects.nonNull(schema.getAuthenticatedPoints())) {
            schema.getAuthenticatedPoints().stream().filter(ap -> {
                N2oPageAccessPoint n2oPageAccessPoint;
                return ap instanceof N2oPageAccessPoint && (n2oPageAccessPoint = (N2oPageAccessPoint)ap).getPage().equals(originPageId);
            }).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
                if (list.size() == 1) {
                    securityObject.setAuthenticated(true);
                }
                return list;
            }));
        }
        if (Objects.nonNull(schema.getAnonymousPoints())) {
            schema.getAnonymousPoints().stream().filter(ap -> {
                N2oPageAccessPoint n2oPageAccessPoint;
                return ap instanceof N2oPageAccessPoint && (n2oPageAccessPoint = (N2oPageAccessPoint)ap).getPage().equals(originPageId);
            }).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
                if (list.size() == 1) {
                    securityObject.setAnonymous(true);
                }
                return list;
            }));
        }
        if (CollectionUtils.isNotEmpty(roles = PermissionAndRoleCollector.collectRoles(N2oPageAccessPoint.class, PermissionAndRoleCollector.PAGE_ACCESS.apply(originPageId), schema))) {
            securityObject.setRoles(roles.stream().map(N2oRole::getId).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(permissions = PermissionAndRoleCollector.collectPermission(N2oPageAccessPoint.class, PermissionAndRoleCollector.PAGE_ACCESS.apply(originPageId), schema))) {
            securityObject.setPermissions(permissions.stream().map(N2oPermission::getId).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(userAccesses = PermissionAndRoleCollector.collectUsers(N2oPageAccessPoint.class, PermissionAndRoleCollector.PAGE_ACCESS.apply(originPageId), schema))) {
            securityObject.setUsernames(userAccesses.stream().map(N2oUserAccess::getId).collect(Collectors.toSet()));
        }
        if (securityObject.isEmpty()) {
            Boolean defaultPageAccessDenied = (Boolean)p.resolve(Placeholders.property((String)DEFAULT_PAGE_ACCESS_DENIED), Boolean.class);
            securityObject.setPermitAll(defaultPageAccessDenied == false);
            securityObject.setDenied(defaultPageAccessDenied);
        }
        if (security.isEmpty()) {
            security.add(new HashMap());
        }
        ((Map)security.get(0)).put("page", securityObject);
    }

    protected void collectUrlAccess(PropertiesAware compiled, String url, SimpleCompiledAccessSchema schema, CompileProcessor p) {
        List<N2oUserAccess> userAccesses;
        List<N2oPermission> permissions;
        List<N2oRole> roles;
        if (Objects.isNull(url)) {
            return;
        }
        Security security = this.getSecurity(compiled);
        if (CollectionUtils.isNotEmpty((Collection)security) && (Objects.nonNull(((Map)security.get(0)).get("url")) || Objects.nonNull(((Map)security.get(0)).get(CUSTOM)))) {
            return;
        }
        SecurityObject securityObject = new SecurityObject();
        if (Objects.nonNull(schema.getPermitAllPoints())) {
            schema.getPermitAllPoints().stream().filter(ap -> {
                N2oUrlAccessPoint n2oUrlAccessPoint;
                return ap instanceof N2oUrlAccessPoint && (n2oUrlAccessPoint = (N2oUrlAccessPoint)ap).getMatcher().matches(url);
            }).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
                if (list.size() == 1) {
                    securityObject.setPermitAll(true);
                }
                return list;
            }));
        }
        if (Objects.nonNull(schema.getAuthenticatedPoints())) {
            schema.getAuthenticatedPoints().stream().filter(ap -> {
                N2oUrlAccessPoint n2oUrlAccessPoint;
                return ap instanceof N2oUrlAccessPoint && (n2oUrlAccessPoint = (N2oUrlAccessPoint)ap).getMatcher().matches(url);
            }).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
                if (list.size() == 1) {
                    securityObject.setAuthenticated(true);
                }
                return list;
            }));
        }
        if (Objects.nonNull(schema.getAnonymousPoints())) {
            schema.getAnonymousPoints().stream().filter(ap -> {
                N2oUrlAccessPoint n2oUrlAccessPoint;
                return ap instanceof N2oUrlAccessPoint && (n2oUrlAccessPoint = (N2oUrlAccessPoint)ap).getMatcher().matches(url);
            }).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
                if (list.size() == 1) {
                    securityObject.setAnonymous(true);
                }
                return list;
            }));
        }
        if (CollectionUtils.isNotEmpty(roles = PermissionAndRoleCollector.collectRoles(N2oUrlAccessPoint.class, PermissionAndRoleCollector.URL_ACCESS.apply(url), schema))) {
            securityObject.setRoles(roles.stream().map(N2oRole::getId).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(permissions = PermissionAndRoleCollector.collectPermission(N2oUrlAccessPoint.class, PermissionAndRoleCollector.URL_ACCESS.apply(url), schema))) {
            securityObject.setPermissions(permissions.stream().map(N2oPermission::getId).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(userAccesses = PermissionAndRoleCollector.collectUsers(N2oUrlAccessPoint.class, PermissionAndRoleCollector.URL_ACCESS.apply(url), schema))) {
            securityObject.setUsernames(userAccesses.stream().map(N2oUserAccess::getId).collect(Collectors.toSet()));
        }
        if (securityObject.isEmpty()) {
            Boolean defaultUrlAccessDenied = (Boolean)p.resolve(Placeholders.property((String)DEFAULT_URL_ACCESS_DENIED), Boolean.class);
            securityObject.setPermitAll(defaultUrlAccessDenied == false);
            securityObject.setDenied(defaultUrlAccessDenied);
        }
        if (security.isEmpty()) {
            security.add(new HashMap());
        }
        ((Map)security.get(0)).put("url", securityObject);
    }

    private Security getSecurity(PropertiesAware compiled) {
        if (Objects.isNull(compiled.getProperties())) {
            compiled.setProperties(new HashMap());
        }
        if (Objects.isNull(compiled.getProperties().get("security"))) {
            compiled.getProperties().put("security", new Security());
        }
        return (Security)compiled.getProperties().get("security");
    }

    protected void transfer(PropertiesAware from, PropertiesAware to) {
        if (Objects.isNull(from) || Objects.isNull(from.getProperties())) {
            return;
        }
        Map properties = from.getProperties();
        if (Objects.isNull(properties) || Objects.isNull(properties.get("security")) || Objects.nonNull(to.getProperties()) && to.getProperties().containsKey("security")) {
            return;
        }
        if (Objects.isNull(to.getProperties())) {
            to.setProperties(new HashMap());
        }
        to.getProperties().put("security", properties.get("security"));
    }

    protected void merge(PropertiesAware destination, List<? extends PropertiesAware> sources) {
        if (Objects.isNull(destination) || Objects.isNull(sources) || Objects.nonNull(destination.getProperties()) && Objects.nonNull(destination.getProperties().get("security"))) {
            return;
        }
        List list = sources.stream().filter(pa -> Objects.nonNull(pa.getProperties()) && pa.getProperties().containsKey("security") && CollectionUtils.isNotEmpty((Collection)((Security)pa.getProperties().get("security")))).flatMap(pa -> ((Security)pa.getProperties().get("security")).stream()).toList();
        if (CollectionUtils.isNotEmpty(list)) {
            if (Objects.isNull(destination.getProperties())) {
                destination.setProperties(new HashMap());
            }
            destination.getProperties().put("security", new Security(list));
        }
    }

    protected void collectObjectFilters(PropertiesAware compiled, String objectId, String operationId, SimpleCompiledAccessSchema schema) {
        if (Objects.isNull(objectId)) {
            return;
        }
        if (Objects.isNull(compiled.getProperties())) {
            compiled.setProperties(new HashMap());
        }
        if (Objects.isNull(compiled.getProperties().get("securityFilters"))) {
            compiled.getProperties().put("securityFilters", new SecurityFilters());
        }
        SecurityFilters securityFilters = (SecurityFilters)compiled.getProperties().get("securityFilters");
        this.collectFilters(objectId, schema, securityFilters);
        this.collectRemoveFilters(objectId, operationId, schema, securityFilters);
    }

    private void collectRemoveFilters(String objectId, String operationId, SimpleCompiledAccessSchema schema, SecurityFilters securityFilters) {
        if (Objects.nonNull(schema.getN2oRoles())) {
            HashMap<String, Set<String>> removeRoleFilters = new HashMap<String, Set<String>>();
            schema.getN2oRoles().stream().filter(r -> Objects.nonNull(r.getAccessPoints())).forEach(r -> this.collectRemoveFilters(objectId, operationId, removeRoleFilters, r.getAccessPoints(), r.getId()));
            if (MapUtils.isNotEmpty(removeRoleFilters)) {
                securityFilters.setRemoveRoleFilters(removeRoleFilters);
            }
        }
        if (Objects.nonNull(schema.getN2oPermissions())) {
            HashMap<String, Set<String>> removePermissionFilters = new HashMap<String, Set<String>>();
            schema.getN2oPermissions().stream().filter(r -> Objects.nonNull(r.getAccessPoints())).forEach(r -> this.collectRemoveFilters(objectId, operationId, removePermissionFilters, r.getAccessPoints(), r.getId()));
            if (MapUtils.isNotEmpty(removePermissionFilters)) {
                securityFilters.setRemovePermissionFilters(removePermissionFilters);
            }
        }
        if (Objects.nonNull(schema.getN2oUserAccesses())) {
            HashMap<String, Set<String>> removeUserFilters = new HashMap<String, Set<String>>();
            schema.getN2oUserAccesses().stream().filter(r -> Objects.nonNull(r.getAccessPoints())).forEach(r -> this.collectRemoveFilters(objectId, operationId, removeUserFilters, r.getAccessPoints(), r.getId()));
            if (MapUtils.isNotEmpty(removeUserFilters)) {
                securityFilters.setRemoveUserFilters(removeUserFilters);
            }
        }
        if (Objects.nonNull(schema.getAuthenticatedPoints())) {
            securityFilters.setRemoveAuthenticatedFilters(this.collectRemoveFilters(objectId, operationId, schema.getAuthenticatedPoints()));
        }
        if (Objects.nonNull(schema.getAnonymousPoints())) {
            securityFilters.setRemoveAnonymousFilters(this.collectRemoveFilters(objectId, operationId, schema.getAnonymousPoints()));
        }
        if (Objects.nonNull(schema.getPermitAllPoints())) {
            securityFilters.setRemovePermitAllFilters(this.collectRemoveFilters(objectId, operationId, schema.getPermitAllPoints()));
        }
    }

    private Set<String> collectRemoveFilters(String objectId, String operationId, List<AccessPoint> accessPoints) {
        return Objects.isNull(accessPoints) ? null : accessPoints.stream().filter(ap -> this.checkByObjectAndOperation(objectId, operationId, (AccessPoint)ap)).flatMap(ap -> Stream.of(((N2oObjectAccessPoint)ap).getRemoveFilters())).collect(Collectors.toSet());
    }

    private void collectRemoveFilters(String objectId, String operationId, Map<String, Set<String>> removePermissionFilters, AccessPoint[] accessPoints, String id) {
        if (Objects.isNull(accessPoints)) {
            return;
        }
        HashSet<String> rf = new HashSet<String>();
        for (AccessPoint ap : accessPoints) {
            if (!this.checkByObjectAndOperation(objectId, operationId, ap)) continue;
            rf.addAll(Arrays.asList(((N2oObjectAccessPoint)ap).getRemoveFilters()));
        }
        if (CollectionUtils.isNotEmpty(rf)) {
            removePermissionFilters.put(id, rf);
        }
    }

    private void collectFilters(String objectId, SimpleCompiledAccessSchema schema, SecurityFilters securityFilters) {
        if (Objects.nonNull(schema.getN2oRoles())) {
            HashMap<String, List<N2oObjectFilter>> roleFilters = new HashMap<String, List<N2oObjectFilter>>();
            schema.getN2oRoles().stream().filter(r -> Objects.nonNull(r.getAccessPoints())).forEach(r -> this.collectFiltersFromAccessPoints(objectId, roleFilters, r.getAccessPoints(), r.getId()));
            if (MapUtils.isNotEmpty(roleFilters)) {
                securityFilters.setRoleFilters(roleFilters);
            }
        }
        if (Objects.nonNull(schema.getN2oPermissions())) {
            HashMap<String, List<N2oObjectFilter>> permissionFilters = new HashMap<String, List<N2oObjectFilter>>();
            schema.getN2oPermissions().stream().filter(p -> Objects.nonNull(p.getAccessPoints())).forEach(p -> this.collectFiltersFromAccessPoints(objectId, permissionFilters, p.getAccessPoints(), p.getId()));
            if (MapUtils.isNotEmpty(permissionFilters)) {
                securityFilters.setPermissionFilters(permissionFilters);
            }
        }
        if (Objects.nonNull(schema.getN2oUserAccesses())) {
            HashMap<String, List<N2oObjectFilter>> userFilters = new HashMap<String, List<N2oObjectFilter>>();
            schema.getN2oUserAccesses().stream().filter(u -> Objects.nonNull(u.getAccessPoints())).forEach(u -> this.collectFiltersFromAccessPoints(objectId, userFilters, u.getAccessPoints(), u.getId()));
            if (MapUtils.isNotEmpty(userFilters)) {
                securityFilters.setUserFilters(userFilters);
            }
        }
        if (Objects.nonNull(schema.getAuthenticatedPoints())) {
            securityFilters.setAuthenticatedFilters(this.collectFiltersFromAccessPointList(objectId, schema.getAuthenticatedPoints()));
        }
        if (Objects.nonNull(schema.getAnonymousPoints())) {
            securityFilters.setAnonymousFilters(this.collectFiltersFromAccessPointList(objectId, schema.getAnonymousPoints()));
        }
        if (Objects.nonNull(schema.getPermitAllPoints())) {
            securityFilters.setPermitAllFilters(this.collectFiltersFromAccessPointList(objectId, schema.getPermitAllPoints()));
        }
    }

    private List<N2oObjectFilter> collectFiltersFromAccessPointList(String objectId, List<AccessPoint> accessPoints) {
        return Objects.isNull(accessPoints) ? null : accessPoints.stream().filter(ap -> this.checkByObject(objectId, (AccessPoint)ap)).flatMap(ap -> Stream.of(((N2oObjectFiltersAccessPoint)ap).getFilters())).toList();
    }

    private void collectFiltersFromAccessPoints(String objectId, Map<String, List<N2oObjectFilter>> filters, AccessPoint[] accessPoints, String id) {
        for (AccessPoint ap : accessPoints) {
            if (!this.checkByObject(objectId, ap)) continue;
            filters.put(id, Arrays.asList(((N2oObjectFiltersAccessPoint)ap).getFilters()));
        }
    }

    private boolean checkByObject(String objectId, AccessPoint ap) {
        N2oObjectFiltersAccessPoint n2oObjectFiltersAccessPoint;
        return ap instanceof N2oObjectFiltersAccessPoint && StringUtils.maskMatch((String)(n2oObjectFiltersAccessPoint = (N2oObjectFiltersAccessPoint)ap).getObjectId(), (String)objectId) && Objects.nonNull(n2oObjectFiltersAccessPoint.getFilters());
    }

    private boolean checkByObjectAndOperation(String objectId, String operationId, AccessPoint ap) {
        N2oObjectAccessPoint n2oObjectAccessPoint;
        return ap instanceof N2oObjectAccessPoint && StringUtils.maskMatch((String)(n2oObjectAccessPoint = (N2oObjectAccessPoint)ap).getObjectId(), (String)objectId) && (Objects.isNull(operationId) || StringUtils.maskMatch((String)n2oObjectAccessPoint.getAction(), (String)operationId)) && Objects.nonNull(n2oObjectAccessPoint.getRemoveFilters());
    }
}

