/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.access.integration;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.n2oapp.criteria.api.CollectionPage;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.access.data.SecurityProvider;
import net.n2oapp.framework.access.metadata.Security;
import net.n2oapp.framework.access.metadata.SecurityFilters;
import net.n2oapp.framework.api.criteria.Restriction;
import net.n2oapp.framework.api.metadata.aware.PropertiesAware;
import net.n2oapp.framework.api.metadata.global.view.page.DefaultValuesModeEnum;
import net.n2oapp.framework.api.processing.DataProcessing;
import net.n2oapp.framework.api.ui.ActionRequestInfo;
import net.n2oapp.framework.api.ui.ActionResponseInfo;
import net.n2oapp.framework.api.ui.QueryRequestInfo;
import net.n2oapp.framework.api.ui.QueryResponseInfo;

public class N2oSecurityModule
implements DataProcessing {
    private SecurityProvider securityProvider;
    private boolean filteringForUnique;

    public N2oSecurityModule(SecurityProvider securityProvider, boolean filteringForUnique) {
        this.securityProvider = securityProvider;
        this.filteringForUnique = filteringForUnique;
    }

    public void processAction(ActionRequestInfo requestInfo, ActionResponseInfo responseInfo, DataSet dataSet) {
        this.securityProvider.checkAccess(this.getSecurityObject((PropertiesAware)requestInfo.getOperation()), requestInfo.getUser());
        this.securityProvider.checkObjectRestrictions(dataSet, this.getSecurityFilters((PropertiesAware)requestInfo.getOperation()), requestInfo.getUser());
    }

    public void processQuery(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo) {
        Security security;
        if (requestInfo.getMode().equals((Object)DefaultValuesModeEnum.QUERY) && (security = this.getSecurityObject((PropertiesAware)requestInfo.getQuery())) != null) {
            this.securityProvider.checkAccess(security, requestInfo.getUser());
            if (requestInfo.getSize() != 1 || this.filteringForUnique) {
                List<Restriction> securityFilters = this.securityProvider.collectRestrictions(this.getSecurityFilters((PropertiesAware)requestInfo.getQuery()), requestInfo.getUser());
                requestInfo.getCriteria().addRestrictions(securityFilters);
            }
        }
    }

    public void processQueryResult(QueryRequestInfo requestInfo, QueryResponseInfo responseInfo, CollectionPage<DataSet> page) {
        if (DefaultValuesModeEnum.QUERY.equals((Object)requestInfo.getMode()) && requestInfo.getSize() == 1) {
            DataSet data = (DataSet)page.getCollection().iterator().next();
            this.securityProvider.checkAccess(this.getSecurityObject((PropertiesAware)requestInfo.getQuery()), requestInfo.getUser());
            this.securityProvider.checkQueryRestrictions(data, this.getSecurityFilters((PropertiesAware)requestInfo.getQuery()), requestInfo.getUser(), requestInfo.getQuery().getFiltersMap());
        }
    }

    private Security getSecurityObject(PropertiesAware propertiesAware) {
        Map properties = propertiesAware.getProperties();
        if (properties == null || !properties.containsKey("security") || properties.get("security") == null) {
            return null;
        }
        return (Security)properties.get("security");
    }

    private SecurityFilters getSecurityFilters(PropertiesAware propertiesAware) {
        Map properties = propertiesAware.getProperties();
        if (properties == null || !properties.containsKey("securityFilters")) {
            return null;
        }
        return (SecurityFilters)properties.get("securityFilters");
    }

    @Generated
    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    @Generated
    public void setFilteringForUnique(boolean filteringForUnique) {
        this.filteringForUnique = filteringForUnique;
    }
}

