/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.access.api.model;

import java.util.Collections;
import java.util.List;
import net.n2oapp.framework.access.api.model.AccessDeniedScopeEnum;
import net.n2oapp.framework.access.api.model.Permission;
import net.n2oapp.framework.access.api.model.filter.N2oAccessFilter;

public class ObjectPermission
extends Permission {
    private String objectId;
    private List<N2oAccessFilter> accessFilters;
    private AccessDeniedScopeEnum accessDeniedScope = AccessDeniedScopeEnum.OBJECT;

    public static ObjectPermission denied(String detailedMessage, String techMessage) {
        ObjectPermission res = new ObjectPermission(false);
        res.setDetailedMessage(detailedMessage);
        res.setTechMessage(techMessage);
        return res;
    }

    public static ObjectPermission allowed(String techMessage) {
        ObjectPermission res = new ObjectPermission(true);
        res.setTechMessage(techMessage);
        return res;
    }

    public AccessDeniedScopeEnum getAccessDeniedScope() {
        return this.accessDeniedScope;
    }

    public void setAccessDeniedScope(AccessDeniedScopeEnum accessDeniedScope) {
        this.accessDeniedScope = accessDeniedScope;
    }

    public ObjectPermission(boolean allowed) {
        super(allowed);
    }

    public ObjectPermission(boolean allowed, String objectId) {
        super(allowed);
        this.objectId = objectId;
    }

    public List<N2oAccessFilter> getAccessFilters() {
        if (this.accessFilters == null) {
            return Collections.emptyList();
        }
        return this.accessFilters;
    }

    public void setAccessFilters(List<N2oAccessFilter> accessFilters) {
        this.accessFilters = accessFilters;
    }

    public String getObjectId() {
        return this.objectId;
    }
}

