/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.access.api.model;

import java.util.List;
import java.util.Optional;
import net.n2oapp.framework.access.api.model.Permission;

public class ComplexPermission
extends Permission {
    private List<Permission> permissions;

    public ComplexPermission(List<Permission> permissions) {
        super(ComplexPermission.resolve(permissions));
        for (Permission permission : permissions) {
            if (permission.isAllowed()) continue;
            this.setDetailedMessage(permission.getDetailedMessage());
            this.setTechMessage(permission.getTechMessage());
        }
        this.permissions = permissions;
    }

    private static boolean resolve(List<Permission> permissions) {
        for (Permission permission : permissions) {
            if (permission.isAllowed()) continue;
            return false;
        }
        return true;
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public <T extends Permission> Optional<T> getPermissionByType(Class<T> type) {
        return this.permissions.stream().map(p -> {
            Optional optional;
            if (p instanceof ComplexPermission) {
                ComplexPermission complexPermission = (ComplexPermission)p;
                optional = complexPermission.getPermissionByType(type);
            } else {
                optional = Optional.empty();
            }
            Optional res = optional;
            return res.isPresent() ? (Permission)res.get() : p;
        }).filter(p -> p.getClass() == type).findFirst();
    }
}

